/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.assignment;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.common.IMutableResourceGroup;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.common.IMutableResourcePool;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.common.WholeGroupPool;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.assignment.BaseSingleGroupAssignmentRestriction;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.assignment.IResourcePool;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.assignment.ResourcePool;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.IResourceGroup;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.resources.IWorkResource;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.AssignmentResource;
import com.atlassian.rm.jpo.scheduling.util.RmIdentifiableUtils;
import com.google.common.base.Optional;
import com.google.common.collect.Sets;
import java.util.Set;
import javax.annotation.concurrent.Immutable;

@Immutable
public class FixedResourceGroupAssignmentRestriction
extends BaseSingleGroupAssignmentRestriction {
    public FixedResourceGroupAssignmentRestriction(IResourceGroup resourceGroup) {
        super(resourceGroup);
    }

    public FixedResourceGroupAssignmentRestriction(IResourceGroup resourceGroup, int workSlotIndex) {
        super(workSlotIndex, resourceGroup);
    }

    @Override
    public Set<IMutableResourcePool> filterMutableResourcePools(Set<IMutableResourceGroup> mutableResourceGroups) {
        Optional<IMutableResourceGroup> mutableResourceGroup = RmIdentifiableUtils.tryFindElementWithId(this.resourceGroup.getId(), mutableResourceGroups);
        if (!mutableResourceGroup.isPresent()) {
            return Sets.newHashSet();
        }
        WholeGroupPool resourcePool = new WholeGroupPool((IMutableResourceGroup)mutableResourceGroup.get());
        return Sets.newHashSet((Object[])new IMutableResourcePool[]{resourcePool});
    }

    @Override
    public Set<IResourcePool> getResourcePools() {
        ResourcePool pool = new ResourcePool(this.resourceGroup);
        return Sets.newHashSet((Object[])new IResourcePool[]{pool});
    }

    @Override
    public Set<IWorkResource> getResources() {
        return this.resourceGroup.getResources();
    }

    @Override
    public Set<AssignmentResource> filterResources(Set<AssignmentResource> skillRelevantResources) {
        return RmIdentifiableUtils.getElementsWithIds(RmIdentifiableUtils.getIds(this.resourceGroup.getResources()), skillRelevantResources);
    }

    public String toString() {
        return "FixedResourceGroupAssignmentRestriction{group=" + this.resourceGroup.getId() + "slotIndex=" + this.getWorkSlotIndex().orNull() + '}';
    }
}

