/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.assignment;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.assignment.IResourcePool;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.IResourceGroup;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.resources.IWorkResource;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IResourceType;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.util.RmSchedulingUtils;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.util.Set;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

@Immutable
public class ResourcePool
implements IResourcePool {
    private final IResourceGroup resourceGroup;
    private final Set<IWorkResource> resources;
    private final Set<IResourceType> availableTypes;

    public ResourcePool(IResourceGroup resourceGroup) {
        this(resourceGroup, resourceGroup.getResources());
    }

    public ResourcePool(IResourceGroup resourceGroup, Set<IWorkResource> selectedResources) {
        Preconditions.checkNotNull((Object)resourceGroup, (Object)"resourceGroup must not be null");
        Preconditions.checkNotNull(selectedResources, (Object)"resource set must not be null");
        this.resourceGroup = resourceGroup;
        this.resources = selectedResources;
        this.availableTypes = RmSchedulingUtils.getMergedResourceTypes(selectedResources);
    }

    @Override
    public String getId() {
        return this.resourceGroup.getId();
    }

    @Override
    public Set<IWorkResource> getResources() {
        return this.resources;
    }

    @Override
    public IResourceGroup getResourceGroup() {
        return this.resourceGroup;
    }

    @Override
    public Set<IResourceType> getResourceTypes() {
        return this.availableTypes;
    }

    public final int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, new String[0]);
    }

    public final boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, obj, new String[0]);
    }

    public String toString() {
        return "ResourcePool [resourceGroup=" + this.resourceGroup + ", resources=" + Joiner.on((String)",").join(this.resources) + "]";
    }
}

