/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.IWorkSlot;
import com.atlassian.rm.jpo.scheduling.util.function.IIntegerInterval;
import com.atlassian.rm.jpo.scheduling.util.function.IntegerInterval;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import javax.annotation.concurrent.Immutable;

@Immutable
abstract class BaseWorkSlot
implements IWorkSlot {
    final IIntegerInterval interval;
    final int index;
    final String groupId;
    final boolean restricted;

    BaseWorkSlot(String groupId, int start, int end, int index, boolean restricted) {
        this.groupId = (String)Preconditions.checkNotNull((Object)groupId, (Object)"group id must not be null");
        Preconditions.checkArgument((start <= end ? 1 : 0) != 0, (Object)"illegal interval");
        this.index = index;
        this.interval = new IntegerInterval(start, end);
        this.restricted = restricted;
    }

    @Override
    public int getStart() {
        return this.interval.getStart();
    }

    @Override
    public int getEnd() {
        return this.interval.getEnd();
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public int getLength() {
        return this.interval.getLength();
    }

    @Override
    public boolean contains(int value) {
        return this.interval.contains(value);
    }

    @Override
    public Optional<IIntegerInterval> getOverlappingInterval(IIntegerInterval interval) {
        return this.interval.getOverlappingInterval(interval);
    }

    @Override
    public String getGroupId() {
        return this.groupId;
    }

    @Override
    public boolean isRestricted() {
        return this.restricted;
    }

    public final int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.groupId == null ? 0 : this.groupId.hashCode());
        result = 31 * result + this.index;
        return result;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IWorkSlot)) {
            return false;
        }
        IWorkSlot other = (IWorkSlot)obj;
        if (this.groupId == null ? other.getGroupId() != null : !this.groupId.equals(other.getGroupId())) {
            return false;
        }
        return this.index == other.getIndex();
    }
}

