/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.resources;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.IWorkSlot;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.WorkSlotsDefinition;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.resources.IStepWiseResourceAvailability;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.resources.IStepWiseResourcePresence;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.resources.IWorkSlotFunction;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.resources.StepWiseWorkSlotFunction;
import com.google.common.base.Optional;
import java.util.Map;

public class PlannedCapacityWorkSlotFunction
implements IWorkSlotFunction {
    private final WorkSlotsDefinition workSlotsDefinition;
    private final IStepWiseResourcePresence presence;
    private final IStepWiseResourceAvailability availability;
    private final StepWiseWorkSlotFunction stepWiseWorkSlotFunction;
    private final Map<Long, Double> capacityPerSprintId;
    private final float ratio;

    public PlannedCapacityWorkSlotFunction(WorkSlotsDefinition workSlotsDefinition, IStepWiseResourcePresence presence, IStepWiseResourceAvailability availability, float ratio, Map<Long, Double> capacityPerSprintId) {
        this.workSlotsDefinition = workSlotsDefinition;
        this.presence = presence;
        this.availability = availability;
        this.capacityPerSprintId = capacityPerSprintId;
        this.ratio = ratio;
        this.stepWiseWorkSlotFunction = new StepWiseWorkSlotFunction(presence, availability, workSlotsDefinition);
    }

    @Override
    public float getUnassignedWorkInWorkSlot(int slotIndex) {
        if (this.workSlotsDefinition.isRestrictedWorkSlot(slotIndex)) {
            return 0.0f;
        }
        return this.getRestrictedAvailability(slotIndex);
    }

    @Override
    public float getRestrictedAvailability(int slotIndex) {
        Long iSlotId;
        IWorkSlot workSlot = this.workSlotsDefinition.getWorkSlotWithIndex(slotIndex);
        Optional<String> slotId = workSlot.tryGetId();
        if (slotId.isPresent() && this.capacityPerSprintId.containsKey(iSlotId = Long.valueOf((String)slotId.get()))) {
            return (float)(this.capacityPerSprintId.get(iSlotId) * (double)this.ratio);
        }
        return this.stepWiseWorkSlotFunction.getRestrictedAvailability(slotIndex);
    }

    @Override
    public int getFirstRegularTimeStep() {
        return Math.max(this.presence.getFirstRegularTimeStep(), this.availability.getFirstRegularTimeStep());
    }

    @Override
    public boolean isPositiveEnding() {
        return true;
    }
}

