/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.IWorkSlot;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution.IActivitySchedule;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution.ISingleResourceGroupAssignment;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution.IWorkAssignment;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IActivity;
import com.atlassian.rm.jpo.scheduling.util.function.IIntegerInterval;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.Set;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ActivitySchedule
implements IActivitySchedule {
    private final IActivity activity;
    private final ISingleResourceGroupAssignment assignment;
    private final int releaseTime;

    public ActivitySchedule(IActivity activity, ISingleResourceGroupAssignment assignment, int releaseTime) {
        Preconditions.checkNotNull((Object)activity, (Object)"activity must not be null");
        Preconditions.checkNotNull((Object)assignment, (Object)"assignment must not be null");
        this.activity = activity;
        this.assignment = assignment;
        this.releaseTime = releaseTime;
    }

    @Override
    public IActivity getActivity() {
        return this.activity;
    }

    @Override
    public int getEnd() {
        return this.assignment.getEnd();
    }

    @Override
    public int getStart() {
        return this.assignment.getStart();
    }

    @Override
    public String getId() {
        return this.activity.getId();
    }

    @Override
    public Set<IWorkAssignment> getWorkAssignments() {
        return this.assignment.getWorkAssignments();
    }

    @Override
    public int getLength() {
        return this.assignment.getLength();
    }

    @Override
    public boolean contains(int value) {
        return this.assignment.contains(value);
    }

    @Override
    public Optional<IIntegerInterval> getOverlappingInterval(IIntegerInterval interval) {
        return this.assignment.getOverlappingInterval(interval);
    }

    @Override
    public Set<IWorkSlot> getUsedWorkSlots() {
        return this.assignment.getUsedWorkSlots();
    }

    @Override
    public int getReleaseTime() {
        return this.releaseTime;
    }
}

