/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.actset.act.StageTaskProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.AssignmentResource;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.AssignmentSearchState;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.BoundAssignmentProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.MathUtil;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.SearchStateComparator;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.search.AssignmentCandidate;
import com.atlassian.rm.jpo.scheduling.util.search.SearchState;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Set;
import org.uncommons.maths.combinatorics.CombinationGenerator;

class LevelWiseExhaustingQueueCreator {
    LevelWiseExhaustingQueueCreator() {
    }

    static PriorityQueue<SearchState<AssignmentCandidate>> initializeQueue(BoundAssignmentProblem problem) throws InterruptedException {
        List problemsCombinations = LevelWiseExhaustingQueueCreator.generateAllCombinationsForAllSubTaskProblems(problem.getStageTaskProblems());
        int[][] allCombinationsAsIndexMatrix = MathUtil.generateAllCombinationsAsMatrix(problemsCombinations);
        PriorityQueue<SearchState<AssignmentCandidate>> queue = new PriorityQueue<SearchState<AssignmentCandidate>>(allCombinationsAsIndexMatrix.length, new SearchStateComparator());
        for (int solutionIndex = 0; solutionIndex < problem.getCombinatorialCount(); ++solutionIndex) {
            ArrayList combination = Lists.newArrayListWithCapacity((int)problem.getStageTaskProblems().size());
            for (int subTaskAssignmentIndex = 0; subTaskAssignmentIndex < allCombinationsAsIndexMatrix[solutionIndex].length; ++subTaskAssignmentIndex) {
                combination.add(problemsCombinations.get(subTaskAssignmentIndex).get(allCombinationsAsIndexMatrix[solutionIndex][subTaskAssignmentIndex]));
            }
            queue.add(AssignmentSearchState.create(combination, problem, problem.getTimeInterval().getStart()));
        }
        return queue;
    }

    private static List<List<Set<AssignmentResource>>> generateAllCombinationsForAllSubTaskProblems(List<StageTaskProblem> stageTaskProblems) {
        List<CombinationGenerator<AssignmentResource>> combinators = LevelWiseExhaustingQueueCreator.createCombinators(stageTaskProblems);
        ArrayList problemsCombinations = Lists.newArrayListWithCapacity((int)combinators.size());
        for (CombinationGenerator<AssignmentResource> combinator : combinators) {
            ArrayList problemCombinations = Lists.newArrayList();
            while (combinator.hasMore()) {
                problemCombinations.add(Sets.newHashSet((Object[])combinator.nextCombinationAsArray()));
            }
            problemsCombinations.add(problemCombinations);
        }
        return problemsCombinations;
    }

    private static List<CombinationGenerator<AssignmentResource>> createCombinators(List<StageTaskProblem> stageTaskProblems) {
        ArrayList combinators = Lists.newArrayListWithCapacity((int)stageTaskProblems.size());
        for (StageTaskProblem problem : stageTaskProblems) {
            combinators.add(LevelWiseExhaustingQueueCreator.createCombinator(problem));
        }
        return combinators;
    }

    private static CombinationGenerator<AssignmentResource> createCombinator(StageTaskProblem problem) {
        return new CombinationGenerator<AssignmentResource>(problem.getSkilledResourceSelection(), Math.min(problem.getMaxResources(), problem.getSkilledResourceSelection().size()));
    }
}

