/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math;

import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.actset.act.StageTaskProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IResourceType;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.AssignmentResource;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.AssignmentSearchState;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.AvailabilityBasedSampling;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.BoundAssignmentProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.GreedyTypeSampling;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.JitFringe;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.SearchStateComparator;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.search.AssignmentCandidate;
import com.atlassian.rm.jpo.scheduling.util.LogUtil;
import com.atlassian.rm.jpo.scheduling.util.collection.MutablePrimitivesMap;
import com.atlassian.rm.jpo.scheduling.util.collection.PrimitivesMap;
import com.atlassian.rm.jpo.scheduling.util.collection.RmCollectionUtils;
import com.atlassian.rm.jpo.scheduling.util.search.SearchState;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Random;
import java.util.Set;

class SamplingQueueCreator {
    private static final Log LOGGER = Log.with(JitFringe.class);
    private final Random random = new Random(7589375829L);
    private final GreedyTypeSampling greedyTypeSampling = new GreedyTypeSampling();
    private final AvailabilityBasedSampling availabilityBasedSampling = new AvailabilityBasedSampling();

    SamplingQueueCreator() {
    }

    PriorityQueue<SearchState<AssignmentCandidate>> createPriorityQueue(BoundAssignmentProblem problem, int maxTestAssignments) throws InterruptedException {
        if (maxTestAssignments <= 0) {
            LogUtil.debug(LOGGER, "no solutions requested");
            return new PriorityQueue<SearchState<AssignmentCandidate>>();
        }
        PriorityQueue<SearchState<AssignmentCandidate>> queue = new PriorityQueue<SearchState<AssignmentCandidate>>(maxTestAssignments, new SearchStateComparator());
        for (List<Set<AssignmentResource>> combination : this.generateCombinations(problem, maxTestAssignments)) {
            AssignmentSearchState state = AssignmentSearchState.create(combination, problem, problem.getTimeInterval().getStart());
            queue.add(state);
        }
        return queue;
    }

    private Set<List<Set<AssignmentResource>>> generateCombinations(BoundAssignmentProblem problem, int maxTestAssignments) {
        HashSet generatedSets = Sets.newHashSet();
        PrimitivesMap<AssignmentResource> availabilities = this.getAvailabilities(problem.getAllSkilledResources(), problem.getTimeInterval().getStart());
        for (int i = 1; i <= maxTestAssignments; ++i) {
            float greedyProbability = (float)i / (float)maxTestAssignments;
            ArrayList combinations = Lists.newArrayListWithCapacity((int)problem.getStageTaskProblems().size());
            for (StageTaskProblem stageTaskProblem : problem.getStageTaskProblems()) {
                HashSet combination = Sets.newHashSetWithExpectedSize((int)stageTaskProblem.getMaxResources());
                while (combination.size() < stageTaskProblem.getMaxResources()) {
                    ArrayList pool = Lists.newArrayList(problem.getAllSkilledResourcesSorted());
                    pool.removeAll(combination);
                    Optional<AssignmentResource> sample = this.getNextSample(pool, availabilities, greedyProbability, combination, stageTaskProblem);
                    if (!sample.isPresent()) break;
                    combination.add(sample.get());
                }
                combinations.add(combination);
            }
            generatedSets.add(combinations);
        }
        return generatedSets;
    }

    private PrimitivesMap<AssignmentResource> getAvailabilities(Collection<AssignmentResource> resources, int timeIndex) {
        MutablePrimitivesMap<AssignmentResource> availabilities = RmCollectionUtils.newMutableMap();
        for (AssignmentResource assignmentResource : resources) {
            availabilities.put(assignmentResource, assignmentResource.getUnassignedWorkInWorkSlot(timeIndex));
        }
        return availabilities;
    }

    private Optional<AssignmentResource> getNextSample(List<AssignmentResource> pool, PrimitivesMap<AssignmentResource> availabilities, float greedyProbability, Set<AssignmentResource> combination, StageTaskProblem stageTaskProblem) {
        if ((double)greedyProbability > this.random.nextDouble()) {
            Set<IResourceType> needed = this.getNeededTypes(combination, stageTaskProblem);
            return this.greedyTypeSampling.sample(pool, needed);
        }
        return this.availabilityBasedSampling.sample(pool, availabilities);
    }

    private Set<IResourceType> getNeededTypes(Set<AssignmentResource> combination, StageTaskProblem stageTaskProblem) {
        HashSet needed = Sets.newHashSet(stageTaskProblem.getDemand().keySet());
        for (AssignmentResource resource : combination) {
            needed.removeAll(resource.getTypes());
        }
        return needed;
    }
}

