/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.util;

import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.common.IMutableResource;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.common.IMutableResourcePool;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.IHasResourceTypes;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.assignment.AssignmentRestriction;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.assignment.IResourcePool;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.IResourceGroup;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution.IWorkAssignment;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IActivity;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IActivitySet;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IProcessingItem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IResourceType;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.ProcessingItemType;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.util.IWorkAssignable;
import com.atlassian.rm.jpo.scheduling.util.LogUtil;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.concurrent.Immutable;

@Immutable
public abstract class RmSchedulingUtils {
    private static final Log LOGGER = Log.with(RmSchedulingUtils.class);

    public static Map<IMutableResource, Set<IResourceType>> getNeededSkillsMap(Set<IMutableResource> mutableResources, Set<IResourceType> neededResourceTypes) {
        Preconditions.checkNotNull(mutableResources, (Object)"set of mutable resources must not be null");
        Preconditions.checkNotNull(neededResourceTypes, (Object)"set of needed resource types must not be null");
        HashMap neededSkillsMap = Maps.newHashMap();
        for (IMutableResource resource : mutableResources) {
            neededSkillsMap.put(resource, Sets.intersection(resource.getResourceTypes(), neededResourceTypes));
        }
        return neededSkillsMap;
    }

    public static <T extends IHasResourceTypes> Set<IResourceType> getMergedResourceTypes(Collection<T> resourceTypeElements) {
        Preconditions.checkNotNull(resourceTypeElements, (Object)"elements must not be null");
        LogUtil.debugCollection(LOGGER, "get resource types from elements: %s", resourceTypeElements);
        HashSet allResourceTypes = Sets.newHashSet();
        for (IHasResourceTypes element : resourceTypeElements) {
            allResourceTypes.addAll(element.getResourceTypes());
        }
        LogUtil.debug(LOGGER, "return needed resource types: %s", allResourceTypes);
        return allResourceTypes;
    }

    public static Set<IWorkAssignment> getWorkAssignments(Set<? extends IWorkAssignable> workAssignables) {
        Preconditions.checkNotNull(workAssignables, (Object)"work units must not be null");
        HashSet assignments = Sets.newHashSet();
        for (IWorkAssignable iWorkAssignable : workAssignables) {
            assignments.addAll(iWorkAssignable.getWorkAssignments());
        }
        return assignments;
    }

    public static Map<IActivity, Set<IResourceGroup>> getPossibleActivityAssignments(Collection<IProcessingItem> processingItems) {
        HashMap map = Maps.newHashMap();
        for (IProcessingItem item : processingItems) {
            if (!item.getProcessingItemType().equals((Object)ProcessingItemType.ActivitySet)) continue;
            IActivitySet activitySet = (IActivitySet)item;
            AssignmentRestriction assignment = item.getAssignmentRestriction();
            Set<IResourceGroup> assignableResourceGroups = RmSchedulingUtils.getResourceGroups(assignment.getResourcePools());
            List<IActivity> activities = activitySet.getActivities();
            for (IActivity activity : activities) {
                map.put(activity, assignableResourceGroups);
            }
        }
        return map;
    }

    private static Set<IResourceGroup> getResourceGroups(Set<IResourcePool> resourcePools) {
        HashSet groups = Sets.newHashSet();
        for (IResourcePool pool : resourcePools) {
            groups.add(pool.getResourceGroup());
        }
        return groups;
    }

    public static float getWorkLoadSum(Set<IWorkAssignment> set) {
        float sum = 0.0f;
        for (IWorkAssignment statistic : set) {
            sum += statistic.getAssignedWorkUnits();
        }
        return sum;
    }

    public static boolean hasUnlimitedResource(Set<IMutableResourcePool> mutableResourcePools) {
        for (IMutableResourcePool pool : mutableResourcePools) {
            Set<IMutableResource> mutableResources = pool.getMutableResources();
            for (IMutableResource resource : mutableResources) {
                if (!resource.isUnlimitedAvailable()) continue;
                return true;
            }
        }
        return false;
    }
}

