/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.util;

import com.atlassian.rm.jpo.scheduling.util.IdentifiableInterval;
import com.atlassian.rm.jpo.scheduling.util.function.IIntegerInterval;
import com.atlassian.rm.jpo.scheduling.util.function.IntegerInterval;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;

public class DefaultIdentifiableInterval
implements IdentifiableInterval {
    private final IIntegerInterval interval;
    private final String id;

    public DefaultIdentifiableInterval(IIntegerInterval interval, String id) {
        this.interval = (IIntegerInterval)Preconditions.checkNotNull((Object)interval);
        this.id = (String)Preconditions.checkNotNull((Object)id);
    }

    public DefaultIdentifiableInterval(int start, int end, String id) {
        this(new IntegerInterval(start, end), id);
    }

    @Override
    public int getStart() {
        return this.interval.getStart();
    }

    @Override
    public int getEnd() {
        return this.interval.getEnd();
    }

    @Override
    public int getLength() {
        return this.interval.getLength();
    }

    @Override
    public boolean contains(int value) {
        return this.interval.contains(value);
    }

    @Override
    public Optional<IIntegerInterval> getOverlappingInterval(IIntegerInterval interval) {
        return this.interval.getOverlappingInterval(interval);
    }

    @Override
    public String getId() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultIdentifiableInterval that = (DefaultIdentifiableInterval)o;
        if (!this.interval.equals(that.interval)) {
            return false;
        }
        return this.id.equals(that.id);
    }

    public int hashCode() {
        int result = this.interval.hashCode();
        result = 31 * result + this.id.hashCode();
        return result;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("interval", (Object)this.interval).add("id", (Object)this.id).toString();
    }
}

