/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.util.collection;

import com.atlassian.rm.jpo.scheduling.util.RmUtils;
import com.atlassian.rm.jpo.scheduling.util.collection.BaseTroveMap;
import com.atlassian.rm.jpo.scheduling.util.collection.ImmutableNonEmptyPositivePrimitivesMap;
import com.atlassian.rm.jpo.scheduling.util.collection.MutablePositiveTroveMap;
import com.atlassian.rm.jpo.scheduling.util.collection.PositivePrimitivesMap;
import com.google.common.base.Optional;
import gnu.trove.map.hash.TObjectFloatHashMap;
import java.util.Map;

public class ImmutableNonEmptyPositiveTroveMap<K>
extends BaseTroveMap<K>
implements ImmutableNonEmptyPositivePrimitivesMap<K> {
    private final float valueSum;

    ImmutableNonEmptyPositiveTroveMap(TObjectFloatHashMap<K> map) {
        super(map);
        this.valueSum = RmUtils.sum(map.values());
    }

    @Override
    public float getValueSum() {
        return this.valueSum;
    }

    public static <K> Optional<ImmutableNonEmptyPositivePrimitivesMap<K>> tryCreate(PositivePrimitivesMap<K> inputMap) {
        if (inputMap.isEmpty()) {
            return Optional.absent();
        }
        MutablePositiveTroveMap<K> mutableMap = MutablePositiveTroveMap.create(inputMap);
        if (mutableMap.isEmpty()) {
            return Optional.absent();
        }
        ImmutableNonEmptyPositiveTroveMap<K> instance = new ImmutableNonEmptyPositiveTroveMap<K>(mutableMap.getTroveMap());
        return Optional.of(instance);
    }

    public static <K> Optional<ImmutableNonEmptyPositivePrimitivesMap<K>> tryCreate(Map<K, Float> inputMap) {
        if (inputMap.isEmpty()) {
            return Optional.absent();
        }
        MutablePositiveTroveMap<K> mutableMap = MutablePositiveTroveMap.create(inputMap);
        if (mutableMap.isEmpty()) {
            return Optional.absent();
        }
        ImmutableNonEmptyPositiveTroveMap<K> instance = new ImmutableNonEmptyPositiveTroveMap<K>(mutableMap.getTroveMap());
        return Optional.of(instance);
    }
}

