/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.util.collection;

import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.jpo.scheduling.util.collection.BaseTroveMap;
import com.atlassian.rm.jpo.scheduling.util.collection.MutablePositivePrimitivesMap;
import com.atlassian.rm.jpo.scheduling.util.collection.PositivePrimitivesMap;
import gnu.trove.map.hash.TObjectFloatHashMap;
import java.util.Map;

public class MutablePositiveTroveMap<K>
extends BaseTroveMap<K>
implements MutablePositivePrimitivesMap<K> {
    private static final Log LOGGER = Log.with(MutablePositiveTroveMap.class);

    public MutablePositiveTroveMap(TObjectFloatHashMap<K> troveMap) {
        super(troveMap);
    }

    @Override
    public void subtract(PositivePrimitivesMap<K> minuend) {
        for (K key : minuend.keySet()) {
            float oldValue;
            float newValue;
            if (!this.troveMap.contains(key) || !((newValue = (oldValue = this.troveMap.remove(key)) - minuend.get(key)) > 0.01f)) continue;
            this.troveMap.put(key, newValue);
        }
    }

    @Override
    public void add(PositivePrimitivesMap<K> summand) {
        for (K key : summand.keySet()) {
            float value = summand.get(key);
            this.add(key, value);
        }
    }

    @Override
    public void put(K key, float value) {
        if (value < 0.01f) {
            this.troveMap.remove(key);
        } else {
            this.troveMap.put(key, value);
        }
    }

    @Override
    public void add(K key, float value) {
        this.troveMap.adjustOrPutValue(key, value, value);
        if (this.troveMap.get(key) < 0.01f) {
            this.troveMap.remove(key);
        }
    }

    @Override
    public void remove(K key) {
        this.troveMap.remove(key);
    }

    public TObjectFloatHashMap<K> getTroveMap() {
        return this.troveMap;
    }

    public static <K> MutablePositiveTroveMap<K> create() {
        TObjectFloatHashMap map = new TObjectFloatHashMap(MutablePositiveTroveMap.capacity(10), 0.75f, -2.1474836E9f);
        MutablePositiveTroveMap instance = new MutablePositiveTroveMap(map);
        return instance;
    }

    public static <K> MutablePositiveTroveMap<K> createWithExpectedSize(int expectedSize) {
        TObjectFloatHashMap map = new TObjectFloatHashMap(MutablePositiveTroveMap.capacity(expectedSize), 0.75f, -2.1474836E9f);
        MutablePositiveTroveMap instance = new MutablePositiveTroveMap(map);
        return instance;
    }

    static int capacity(int expectedSize) {
        if (expectedSize < 3) {
            return expectedSize + 1;
        }
        if (expectedSize < 0x40000000) {
            return expectedSize + expectedSize / 3;
        }
        return Integer.MAX_VALUE;
    }

    public static <K> MutablePositiveTroveMap<K> create(PositivePrimitivesMap<K> map) {
        MutablePositiveTroveMap<K> instance = new MutablePositiveTroveMap<K>(new TObjectFloatHashMap(MutablePositiveTroveMap.capacity(map.size()), 0.75f, -2.1474836E9f));
        for (K key : map.keySet()) {
            instance.put(key, map.get(key));
        }
        return instance;
    }

    public static <K> MutablePositiveTroveMap<K> create(Map<K, Float> map) {
        MutablePositiveTroveMap<K> instance = new MutablePositiveTroveMap<K>(new TObjectFloatHashMap(MutablePositiveTroveMap.capacity(map.size()), 0.75f, -2.1474836E9f));
        for (Map.Entry<K, Float> entry : map.entrySet()) {
            instance.put(entry.getKey(), entry.getValue().floatValue());
        }
        return instance;
    }

    public static <K> MutablePositiveTroveMap<K> of(K key, float value) {
        MutablePositiveTroveMap<K> instance = new MutablePositiveTroveMap<K>(new TObjectFloatHashMap(MutablePositiveTroveMap.capacity(1), 0.75f, -2.1474836E9f));
        instance.put(key, value);
        return instance;
    }
}

