/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.util.function;

import com.atlassian.rm.jpo.scheduling.util.function.IIntegerInterval;
import com.google.common.base.Optional;
import javax.annotation.concurrent.Immutable;

@Immutable
public class IntegerInterval
implements IIntegerInterval {
    public static final IIntegerInterval EMPTY = new IntegerInterval(0, -1);
    private final int upper;
    private final int lower;

    public IntegerInterval(int lower, int upper) {
        this.upper = upper;
        this.lower = lower;
    }

    public IntegerInterval(int value) {
        this.upper = value;
        this.lower = value;
    }

    @Override
    public int getStart() {
        return this.lower;
    }

    @Override
    public int getEnd() {
        return this.upper;
    }

    @Override
    public int getLength() {
        return Math.max(0, this.upper - this.lower + 1);
    }

    @Override
    public Optional<IIntegerInterval> getOverlappingInterval(IIntegerInterval interval) {
        if (this.upper < interval.getStart() || this.lower > interval.getEnd()) {
            return Optional.absent();
        }
        return Optional.of((Object)new IntegerInterval(Math.max(this.lower, interval.getStart()), Math.min(this.upper, interval.getEnd())));
    }

    @Override
    public boolean contains(int value) {
        return value >= this.lower && value <= this.upper;
    }

    public final int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.lower;
        result = 31 * result + this.upper;
        return result;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IntegerInterval)) {
            return false;
        }
        IntegerInterval other = (IntegerInterval)obj;
        if (this.lower != other.lower) {
            return false;
        }
        return this.upper == other.upper;
    }

    public String toString() {
        return "[" + this.lower + ", " + this.upper + "]";
    }
}

