/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.mysema.query.types.Constant;
import com.mysema.query.types.ConstantImpl;
import com.mysema.query.types.Expression;
import com.mysema.query.types.Operation;
import com.mysema.query.types.OperationImpl;
import com.mysema.query.types.Ops;
import com.mysema.query.types.Template;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TemplateFactory {
    public static final TemplateFactory DEFAULT = new TemplateFactory('\\');
    private static final Constant<String> PERCENT = ConstantImpl.create("%");
    private static final Pattern elementPattern = Pattern.compile("\\{(%?%?)(\\d+)([slu%]?%?)\\}");
    private final Map<String, Template> cache = new ConcurrentHashMap<String, Template>();
    private final char escape;
    private final Function<Object, Object> toLowerCase = new Function<Object, Object>(){

        public Object apply(Object arg) {
            if (arg instanceof Constant) {
                return ConstantImpl.create(this.apply(arg.toString()).toString());
            }
            if (arg instanceof Expression) {
                return OperationImpl.create(String.class, Ops.LOWER, (Expression)arg);
            }
            return String.valueOf(arg).toLowerCase(Locale.ENGLISH);
        }
    };
    private final Function<Object, Object> toUpperCase = new Function<Object, Object>(){

        public Object apply(Object arg) {
            if (arg instanceof Constant) {
                return ConstantImpl.create(this.apply(arg.toString()).toString());
            }
            if (arg instanceof Expression) {
                return OperationImpl.create(String.class, Ops.UPPER, (Expression)arg);
            }
            return String.valueOf(arg).toUpperCase(Locale.ENGLISH);
        }
    };
    private final Function<Object, Object> toStartsWithViaLike = new Function<Object, Object>(){

        public Object apply(Object arg) {
            if (arg instanceof Constant) {
                return ConstantImpl.create(this.apply(arg.toString()).toString());
            }
            if (arg instanceof Expression) {
                return OperationImpl.create(String.class, Ops.CONCAT, (Expression)arg, PERCENT);
            }
            return TemplateFactory.this.escapeForLike(String.valueOf(arg)) + "%";
        }
    };
    private final Function<Object, Object> toStartsWithViaLikeLower = new Function<Object, Object>(){

        public Object apply(Object arg) {
            if (arg instanceof Constant) {
                return ConstantImpl.create(this.apply(arg.toString()).toString());
            }
            if (arg instanceof Expression) {
                Operation<String> concated = OperationImpl.create(String.class, Ops.CONCAT, (Expression)arg, PERCENT);
                return OperationImpl.create(String.class, Ops.LOWER, concated);
            }
            return TemplateFactory.this.escapeForLike(String.valueOf(arg).toLowerCase(Locale.ENGLISH)) + "%";
        }
    };
    private final Function<Object, Object> toEndsWithViaLike = new Function<Object, Object>(){

        public Object apply(Object arg) {
            if (arg instanceof Constant) {
                return ConstantImpl.create(this.apply(arg.toString()).toString());
            }
            if (arg instanceof Expression) {
                return OperationImpl.create(String.class, Ops.CONCAT, PERCENT, (Expression)arg);
            }
            return "%" + TemplateFactory.this.escapeForLike(String.valueOf(arg));
        }
    };
    private final Function<Object, Object> toEndsWithViaLikeLower = new Function<Object, Object>(){

        public Object apply(Object arg) {
            if (arg instanceof Constant) {
                return ConstantImpl.create(this.apply(arg.toString()).toString());
            }
            if (arg instanceof Expression) {
                Operation<String> concated = OperationImpl.create(String.class, Ops.CONCAT, PERCENT, (Expression)arg);
                return OperationImpl.create(String.class, Ops.LOWER, concated);
            }
            return "%" + TemplateFactory.this.escapeForLike(String.valueOf(arg).toLowerCase(Locale.ENGLISH));
        }
    };
    private final Function<Object, Object> toContainsViaLike = new Function<Object, Object>(){

        public Object apply(Object arg) {
            if (arg instanceof Constant) {
                return ConstantImpl.create(this.apply(arg.toString()).toString());
            }
            if (arg instanceof Expression) {
                Operation<String> concated = OperationImpl.create(String.class, Ops.CONCAT, PERCENT, (Expression)arg);
                return OperationImpl.create(String.class, Ops.CONCAT, concated, PERCENT);
            }
            return "%" + TemplateFactory.this.escapeForLike(String.valueOf(arg)) + "%";
        }
    };
    private final Function<Object, Object> toContainsViaLikeLower = new Function<Object, Object>(){

        public Object apply(Object arg) {
            if (arg instanceof Constant) {
                return ConstantImpl.create(this.apply(arg.toString()).toString());
            }
            if (arg instanceof Expression) {
                Operation<String> concated = OperationImpl.create(String.class, Ops.CONCAT, PERCENT, (Expression)arg);
                concated = OperationImpl.create(String.class, Ops.CONCAT, concated, PERCENT);
                return OperationImpl.create(String.class, Ops.LOWER, concated);
            }
            return "%" + TemplateFactory.this.escapeForLike(String.valueOf(arg).toLowerCase(Locale.ENGLISH)) + "%";
        }
    };

    public TemplateFactory(char escape) {
        this.escape = escape;
    }

    public Template create(String template) {
        if (this.cache.containsKey(template)) {
            return this.cache.get(template);
        }
        Matcher m = elementPattern.matcher(template);
        ImmutableList.Builder elements = ImmutableList.builder();
        int end = 0;
        while (m.find()) {
            if (m.start() > end) {
                elements.add((Object)new Template.StaticText(template.substring(end, m.start())));
            }
            String premodifiers = m.group(1).toLowerCase(Locale.ENGLISH);
            int index = Integer.parseInt(m.group(2));
            String postmodifiers = m.group(3).toLowerCase(Locale.ENGLISH);
            boolean asString = false;
            Function<Object, Object> transformer = null;
            switch (premodifiers.length()) {
                case 1: {
                    transformer = this.toEndsWithViaLike;
                    break;
                }
                case 2: {
                    transformer = this.toEndsWithViaLikeLower;
                }
            }
            switch (postmodifiers.length()) {
                case 1: {
                    switch (postmodifiers.charAt(0)) {
                        case '%': {
                            if (transformer == null) {
                                transformer = this.toStartsWithViaLike;
                                break;
                            }
                            transformer = this.toContainsViaLike;
                            break;
                        }
                        case 'l': {
                            transformer = this.toLowerCase;
                            break;
                        }
                        case 'u': {
                            transformer = this.toUpperCase;
                            break;
                        }
                        case 's': {
                            asString = true;
                        }
                    }
                    break;
                }
                case 2: {
                    transformer = transformer == null ? this.toStartsWithViaLikeLower : this.toContainsViaLikeLower;
                }
            }
            if (asString) {
                elements.add((Object)new Template.AsString(index));
            } else if (transformer != null) {
                elements.add((Object)new Template.Transformed(index, transformer));
            } else {
                elements.add((Object)new Template.ByIndex(index));
            }
            end = m.end();
        }
        if (end < template.length()) {
            elements.add((Object)new Template.StaticText(template.substring(end)));
        }
        Template rv = new Template(template, (ImmutableList<Template.Element>)elements.build());
        this.cache.put(template, rv);
        return rv;
    }

    public String escapeForLike(String str) {
        StringBuilder rv = new StringBuilder(str.length() + 3);
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (ch == this.escape || ch == '%' || ch == '_') {
                rv.append(this.escape);
            }
            rv.append(ch);
        }
        return rv.toString();
    }
}

