/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types.expr;

import com.mysema.query.types.Expression;
import com.mysema.query.types.Ops;
import com.mysema.query.types.Path;
import com.mysema.query.types.PathImpl;
import com.mysema.query.types.expr.NumberExpression;
import com.mysema.query.types.expr.NumberOperation;
import com.mysema.query.types.expr.TemporalExpression;
import com.mysema.query.types.expr.TimeOperation;
import java.sql.Time;
import javax.annotation.Nullable;

public abstract class TimeExpression<T extends Comparable>
extends TemporalExpression<T> {
    private static final long serialVersionUID = 7360552308332457990L;
    private static final TimeExpression<Time> CURRENT_TIME = TimeExpression.currentTime(Time.class);
    @Nullable
    private volatile NumberExpression<Integer> hours;
    @Nullable
    private volatile NumberExpression<Integer> minutes;
    @Nullable
    private volatile NumberExpression<Integer> seconds;
    @Nullable
    private volatile NumberExpression<Integer> milliseconds;

    public TimeExpression(Expression<T> mixin) {
        super(mixin);
    }

    @Override
    public TimeExpression<T> as(Path<T> alias) {
        return TimeOperation.create(this.getType(), Ops.ALIAS, this.mixin, alias);
    }

    @Override
    public TimeExpression<T> as(String alias) {
        return this.as((Path)new PathImpl(this.getType(), alias));
    }

    public NumberExpression<Integer> hour() {
        if (this.hours == null) {
            this.hours = NumberOperation.create(Integer.class, Ops.DateTimeOps.HOUR, this.mixin);
        }
        return this.hours;
    }

    public NumberExpression<Integer> minute() {
        if (this.minutes == null) {
            this.minutes = NumberOperation.create(Integer.class, Ops.DateTimeOps.MINUTE, this.mixin);
        }
        return this.minutes;
    }

    public NumberExpression<Integer> second() {
        if (this.seconds == null) {
            this.seconds = NumberOperation.create(Integer.class, Ops.DateTimeOps.SECOND, this.mixin);
        }
        return this.seconds;
    }

    public NumberExpression<Integer> milliSecond() {
        if (this.milliseconds == null) {
            this.milliseconds = NumberOperation.create(Integer.class, Ops.DateTimeOps.MILLISECOND, this.mixin);
        }
        return this.milliseconds;
    }

    public static TimeExpression<Time> currentTime() {
        return CURRENT_TIME;
    }

    public static <T extends Comparable> TimeExpression<T> currentTime(Class<T> cl) {
        return TimeOperation.create(cl, Ops.DateTimeOps.CURRENT_TIME, new Expression[0]);
    }
}

