/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types.template;

import com.google.common.collect.ImmutableList;
import com.mysema.query.types.PredicateTemplate;
import com.mysema.query.types.Template;
import com.mysema.query.types.TemplateExpression;
import com.mysema.query.types.TemplateFactory;
import com.mysema.query.types.Visitor;
import com.mysema.query.types.expr.BooleanExpression;
import java.util.List;

public class BooleanTemplate
extends BooleanExpression
implements TemplateExpression<Boolean> {
    private static final long serialVersionUID = 5749369427497731719L;
    public static final BooleanExpression TRUE = BooleanTemplate.create("true");
    public static final BooleanExpression FALSE = BooleanTemplate.create("false");
    private final PredicateTemplate templateMixin;

    public static BooleanExpression create(String template) {
        return new BooleanTemplate(TemplateFactory.DEFAULT.create(template), ImmutableList.of());
    }

    public static BooleanExpression create(String template, Object one) {
        return new BooleanTemplate(TemplateFactory.DEFAULT.create(template), ImmutableList.of((Object)one));
    }

    public static BooleanExpression create(String template, Object one, Object two) {
        return new BooleanTemplate(TemplateFactory.DEFAULT.create(template), ImmutableList.of((Object)one, (Object)two));
    }

    public static BooleanExpression create(String template, Object ... args) {
        return new BooleanTemplate(TemplateFactory.DEFAULT.create(template), ImmutableList.copyOf((Object[])args));
    }

    public static BooleanExpression create(Template template, Object ... args) {
        return new BooleanTemplate(template, ImmutableList.copyOf((Object[])args));
    }

    public BooleanTemplate(Template template, ImmutableList<?> args) {
        super(new PredicateTemplate(template, args));
        this.templateMixin = (PredicateTemplate)this.mixin;
    }

    @Override
    public final <R, C> R accept(Visitor<R, C> v, C context) {
        return v.visit(this.templateMixin, context);
    }

    @Override
    public Object getArg(int index) {
        return this.templateMixin.getArg(index);
    }

    @Override
    public List<?> getArgs() {
        return this.templateMixin.getArgs();
    }

    @Override
    public Template getTemplate() {
        return this.templateMixin.getTemplate();
    }
}

