/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.plugins.jira.utils;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.opensymphony.module.propertyset.PropertySet;
import java.util.List;

public class UserPropertyManagerWrapper {
    private static final String SEPARATOR = ";";
    private PropertySet propertySet;

    public UserPropertyManagerWrapper(PropertySet propertySet) {
        this.propertySet = propertySet;
    }

    public List<String> getStrings(String property) {
        PropertySet propertySet = this.getPropertySet();
        if (!propertySet.exists(property)) {
            return Lists.newArrayList();
        }
        String text = propertySet.getText(property);
        if (text == null) {
            return Lists.newArrayList();
        }
        Object[] split = text.split(SEPARATOR);
        return Lists.newArrayList((Object[])split);
    }

    public void setStrings(String property, Iterable<String> value) {
        PropertySet propertySet = this.getPropertySet();
        String stringValue = Joiner.on((String)SEPARATOR).join(value);
        propertySet.setText(property, stringValue);
    }

    private PropertySet getPropertySet() {
        return this.propertySet;
    }
}

