/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.entities.plans;

import com.google.common.collect.Maps;
import com.radiantminds.roadmap.common.data.entities.plans.SchedulingPlan;
import com.radiantminds.roadmap.common.data.entities.workitems.SchedulingWorkItem;
import java.util.LinkedHashMap;
import java.util.Map;

public class SchedulingPlanUtil {
    private final SchedulingPlan plan;
    private final Map<Integer, LinkedHashMap<String, SchedulingWorkItem>> workItemsByType;

    public SchedulingPlanUtil(SchedulingPlan plan) {
        this.plan = plan;
        this.workItemsByType = Maps.newHashMap();
    }

    public Map<String, SchedulingWorkItem> getWorkItemsByType(Integer workItemType) {
        if (!this.workItemsByType.containsKey(workItemType)) {
            LinkedHashMap retVal = Maps.newLinkedHashMap();
            for (SchedulingWorkItem schedulingWorkItem : this.plan.getWorkItems()) {
                if (!workItemType.equals(schedulingWorkItem.getType())) continue;
                retVal.put(schedulingWorkItem.getId(), schedulingWorkItem);
            }
            this.workItemsByType.put(workItemType, retVal);
        }
        return this.workItemsByType.get(workItemType);
    }
}

