/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.generator;

import com.google.common.base.Optional;
import com.radiantminds.roadmap.common.data.generator.IPlanGeneratorConfiguration;
import com.radiantminds.roadmap.common.data.generator.backlog.IBacklogConfiguration;
import com.radiantminds.roadmap.common.data.generator.settings.ISettingsConfiguration;
import com.radiantminds.roadmap.common.data.generator.teams.ITeamsConfiguration;
import com.radiantminds.roadmap.common.data.generator.time.ITimePlanConfiguration;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class PlanGeneratorConfiguration
implements IPlanGeneratorConfiguration {
    private final ISettingsConfiguration settingsConfiguration;
    private final ITimePlanConfiguration timePlanConfiguration;
    private final ITeamsConfiguration teamsConfiguration;
    private final IBacklogConfiguration backlogConfiguration;
    private final String title;
    private final String description;
    private final Long replanningInstant;

    public PlanGeneratorConfiguration(ISettingsConfiguration settingsConfiguration, ITimePlanConfiguration releaseConfiguration, ITeamsConfiguration teamsConfiguration, IBacklogConfiguration backlogConfiguration, String title, String description, Long replanningInstant) {
        this.settingsConfiguration = settingsConfiguration;
        this.timePlanConfiguration = releaseConfiguration;
        this.teamsConfiguration = teamsConfiguration;
        this.backlogConfiguration = backlogConfiguration;
        this.title = title;
        this.description = description;
        this.replanningInstant = replanningInstant;
    }

    @Override
    public ISettingsConfiguration getSettingsConfiguration() {
        return this.settingsConfiguration;
    }

    @Override
    public ITimePlanConfiguration getTimePlanConfiguration() {
        return this.timePlanConfiguration;
    }

    @Override
    public ITeamsConfiguration getTeamsConfiguration() {
        return this.teamsConfiguration;
    }

    @Override
    public IBacklogConfiguration getBacklogConfiguration() {
        return this.backlogConfiguration;
    }

    @Override
    public Optional<String> getTitle() {
        return Optional.fromNullable((Object)this.title);
    }

    @Override
    public Optional<String> getDescription() {
        return Optional.fromNullable((Object)this.description);
    }

    @Override
    public Optional<Long> getReplanningInstant() {
        return Optional.fromNullable((Object)this.replanningInstant);
    }

    @Override
    public boolean isStreamMode() {
        return !this.timePlanConfiguration.getStreamConfigurations().isEmpty();
    }

    public static class Builder {
        private final ISettingsConfiguration settingsConfiguration;
        private final ITimePlanConfiguration timePlanConfiguration;
        private final ITeamsConfiguration teamsConfiguration;
        private final IBacklogConfiguration backlogConfiguration;
        private String title = null;
        private String description = null;
        private Long replanningInstant = null;

        public Builder(ISettingsConfiguration settingsConfiguration, ITimePlanConfiguration releaseConfiguration, ITeamsConfiguration teamsConfiguration, IBacklogConfiguration backlogConfiguration) {
            this.settingsConfiguration = settingsConfiguration;
            this.timePlanConfiguration = releaseConfiguration;
            this.teamsConfiguration = teamsConfiguration;
            this.backlogConfiguration = backlogConfiguration;
        }

        public Builder withTitle(String title) {
            this.title = title;
            return this;
        }

        public Builder withDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder withReplanningDaysOffset(int days) {
            DateTime now = new DateTime(System.currentTimeMillis(), DateTimeZone.UTC);
            DateTime replanningDate = now.plusDays(days);
            this.replanningInstant = replanningDate.getMillis();
            return this;
        }

        public PlanGeneratorConfiguration build() {
            return new PlanGeneratorConfiguration(this.settingsConfiguration, this.timePlanConfiguration, this.teamsConfiguration, this.backlogConfiguration, this.title, this.description, this.replanningInstant);
        }
    }
}

