/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.generator.backlog;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.radiantminds.roadmap.common.data.generator.GeneratorUtils;
import com.radiantminds.roadmap.common.data.generator.backlog.AbstractWorkItemConfiguration;
import com.radiantminds.roadmap.common.data.generator.backlog.IEpicConfiguration;
import com.radiantminds.roadmap.common.data.generator.backlog.IEstimateConfiguration;
import com.radiantminds.roadmap.common.data.generator.backlog.IStoryConfiguration;
import java.util.List;
import java.util.Set;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class EpicConfiguration
extends AbstractWorkItemConfiguration
implements IEpicConfiguration {
    private final List<IStoryConfiguration> storyConfigurations;

    EpicConfiguration(String title, List<IStoryConfiguration> storyConfigurations, Set<IEstimateConfiguration> estimateConfiguration, String releaseTitle, String teamTitle, String streamTitle, Long earliestStart) {
        super(title, estimateConfiguration, releaseTitle, teamTitle, streamTitle, earliestStart);
        this.storyConfigurations = storyConfigurations;
    }

    @Override
    public List<IStoryConfiguration> getStoryConfigurations() {
        return this.storyConfigurations;
    }

    public static class Builder {
        private final String title;
        private List<IStoryConfiguration> storyConfigurations = Lists.newArrayList();
        private Set<IEstimateConfiguration> estimateConfiguration = Sets.newHashSet();
        private String releaseTitle = null;
        private String teamTitle = null;
        private String streamTitle = null;
        private Long earliestStart = null;

        public Builder(String title) {
            this.title = title;
        }

        public Builder withStoryConfigurations(List<IStoryConfiguration> storyConfigurations) {
            this.storyConfigurations = storyConfigurations;
            return this;
        }

        public Builder withEstimateConfiguration(Set<IEstimateConfiguration> estimateConfiguration) {
            this.estimateConfiguration = estimateConfiguration;
            return this;
        }

        public Builder withReleaseTitle(String releaseTitle) {
            this.releaseTitle = releaseTitle;
            return this;
        }

        public Builder withTeamTitle(String teamTitle) {
            this.teamTitle = teamTitle;
            return this;
        }

        public Builder withStreamTitle(String streamTitle) {
            this.streamTitle = streamTitle;
            return this;
        }

        public Builder withEarliestStart(String startDate) {
            this.earliestStart = GeneratorUtils.parseDate(startDate);
            return this;
        }

        public Builder withEarliestStart(DateTime startDate) {
            this.earliestStart = startDate.withZone(DateTimeZone.UTC).getMillis();
            return this;
        }

        public EpicConfiguration build() {
            return new EpicConfiguration(this.title, this.storyConfigurations, this.estimateConfiguration, this.releaseTitle, this.teamTitle, this.streamTitle, this.earliestStart);
        }
    }
}

