/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.generator.backlog;

import com.google.common.base.Optional;
import com.radiantminds.roadmap.common.data.generator.backlog.IEstimateConfiguration;

public class EstimationConfiguration
implements IEstimateConfiguration {
    private final double value;
    private final String targetType;
    private final String title;

    EstimationConfiguration(double value, String targetType, String title) {
        this.value = value;
        this.targetType = targetType;
        this.title = title;
    }

    @Override
    public Optional<String> getTitle() {
        return Optional.fromNullable((Object)this.title);
    }

    @Override
    public double getValue() {
        return this.value;
    }

    @Override
    public String getTargetType() {
        return this.targetType;
    }

    public static class Builder {
        private final double value;
        private String targetType = "total";
        private String title = null;

        public Builder(double value) {
            this.value = value;
        }

        public Builder targetType(String targetType) {
            this.targetType = targetType;
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            return this;
        }

        public EstimationConfiguration build() {
            return new EstimationConfiguration(this.value, this.targetType, this.title);
        }
    }
}

