/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.generator.settings;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.radiantminds.roadmap.common.data.generator.settings.ISkillConfiguration;
import com.radiantminds.roadmap.common.data.generator.settings.IStageConfiguration;
import java.awt.Color;
import java.util.List;

public class StageConfiguration
implements IStageConfiguration {
    private final String title;
    private final Double percentage;
    private final List<ISkillConfiguration> skillConfigurations;
    private final String colorString;

    StageConfiguration(String title, Double percentage, List<ISkillConfiguration> skillConfigurations, String colorString) {
        this.title = title;
        this.percentage = percentage;
        this.skillConfigurations = skillConfigurations;
        this.colorString = colorString;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public Optional<Double> getPercentage() {
        return Optional.fromNullable((Object)this.percentage);
    }

    @Override
    public List<ISkillConfiguration> getSkillConfigurations() {
        return this.skillConfigurations;
    }

    @Override
    public Optional<String> getColorAsString() {
        return Optional.fromNullable((Object)this.colorString);
    }

    public static class Builder {
        private final String title;
        private Double percentage = null;
        private List<ISkillConfiguration> skillConfigurations = Lists.newArrayList();
        private Color color = Color.BLUE;

        public Builder(String title) {
            this.title = title;
        }

        public Builder withPercentage(Double percentage) {
            this.percentage = percentage;
            return this;
        }

        public Builder withSkillConfigurations(List<ISkillConfiguration> skillConfigurations) {
            this.skillConfigurations = skillConfigurations;
            return this;
        }

        public Builder withColor(Color color) {
            this.color = color;
            return this;
        }

        public StageConfiguration build() {
            return new StageConfiguration(this.title, this.percentage, this.skillConfigurations, Builder.getHexColor(this.color));
        }

        private static String getHexColor(Color color) {
            String rgb = Integer.toHexString(color.getRGB());
            return "#" + rgb.substring(2, rgb.length());
        }
    }
}

