/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.generator.time;

import com.google.common.collect.Lists;
import com.radiantminds.roadmap.common.data.generator.time.IReleaseConfiguration;
import com.radiantminds.roadmap.common.data.generator.time.IStreamConfiguration;
import java.util.Collections;
import java.util.List;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ReleaseStreamConfiguration
implements IStreamConfiguration {
    private final List<IReleaseConfiguration> releaseConfigurations;
    private final String title;

    ReleaseStreamConfiguration(String title, List<IReleaseConfiguration> releaseConfigurations) {
        this.title = title;
        this.releaseConfigurations = Collections.unmodifiableList(releaseConfigurations);
    }

    @Override
    public List<IReleaseConfiguration> getReleaseConfigurations() {
        return this.releaseConfigurations;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public static class Builder {
        private static final String STREAM_TITLE = "streamDummyTitle";
        private String title = "streamDummyTitle";
        private List<IReleaseConfiguration> releaseConfigurations = Lists.newArrayList();

        public Builder withTitle(String title) {
            this.title = title;
            return this;
        }

        public Builder withSingleRelease(IReleaseConfiguration configuration) {
            this.releaseConfigurations = Lists.newArrayList((Object[])new IReleaseConfiguration[]{configuration});
            return this;
        }

        public Builder withReleases(List<IReleaseConfiguration> configurations) {
            this.releaseConfigurations = configurations;
            return this;
        }

        public ReleaseStreamConfiguration build() {
            ReleaseStreamConfiguration instance = new ReleaseStreamConfiguration(this.title, this.releaseConfigurations);
            return instance;
        }
    }
}

