/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.generator.time;

import com.google.common.collect.Lists;
import com.radiantminds.roadmap.common.data.entities.plans.IPlan;
import com.radiantminds.roadmap.common.data.generator.time.IReleaseConfiguration;
import com.radiantminds.roadmap.common.data.generator.time.IStreamConfiguration;
import com.radiantminds.roadmap.common.data.generator.time.ITimePlanConfiguration;
import com.radiantminds.roadmap.common.data.generator.time.ReleasePersistency;
import com.radiantminds.roadmap.common.data.generator.time.StreamPersistency;
import com.radiantminds.roadmap.common.data.persistence.PersistenceException;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioReleasePersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioStreamPersistence;
import java.util.List;
import javax.annotation.concurrent.Immutable;

@Immutable
public class TimePlanPersistency {
    private final StreamPersistency streamPersistency;
    private final ReleasePersistency releasePersistency;

    public TimePlanPersistency(PortfolioStreamPersistence streamPersistence, PortfolioReleasePersistence releasePersistence) {
        this(new StreamPersistency(streamPersistence, releasePersistence), new ReleasePersistency(releasePersistence));
    }

    TimePlanPersistency(StreamPersistency persistency, ReleasePersistency releasePersistency) {
        this.streamPersistency = persistency;
        this.releasePersistency = releasePersistency;
    }

    public void persist(ITimePlanConfiguration timePlanConfiguration, IPlan plan) throws PersistenceException {
        List streamConfigurations = Lists.reverse(timePlanConfiguration.getStreamConfigurations());
        if (streamConfigurations.isEmpty()) {
            List releases = Lists.reverse(timePlanConfiguration.getDefaultStreamReleaseConfigurations());
            for (int index = 0; index < releases.size(); ++index) {
                this.releasePersistency.persistRelease((IReleaseConfiguration)releases.get(index), plan.getStreams().get(0), index, plan);
            }
        } else {
            for (int streamIndex = 0; streamIndex < streamConfigurations.size(); ++streamIndex) {
                this.streamPersistency.persistReleaseStream((IStreamConfiguration)streamConfigurations.get(streamIndex), streamIndex, plan);
            }
        }
    }
}

