/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.integrity.rank;

import com.atlassian.pocketknife.api.logging.Log;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.entities.common.ISortable;
import com.radiantminds.roadmap.common.data.integrity.DatabaseIntegrityConfiguration;
import com.radiantminds.roadmap.common.data.integrity.rank.BaseSortableIntegrityChecker;
import com.radiantminds.roadmap.common.data.integrity.rank.OrderRangeIdentifierIntegrityChecker;
import com.radiantminds.roadmap.common.data.integrity.rank.configurations.RepairConfigurations;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.releases.AORelease;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.AOQueryGenerator;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.BaseAOPersistenceSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.statements.IQuery;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.statements.IUpdate;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@DatabaseIntegrityConfiguration(requires={OrderRangeIdentifierIntegrityChecker.class})
public class SortOrderExistenceIntegrityChecker
extends BaseSortableIntegrityChecker {
    private static final Log LOGGER = Log.with(SortOrderExistenceIntegrityChecker.class);

    @Autowired
    public SortOrderExistenceIntegrityChecker(ActiveObjectsUtilities activeObjectsUtilities) {
        super(LOGGER, activeObjectsUtilities);
    }

    @Override
    protected List<Class<? extends ISortable>> getApplicableTables() {
        ArrayList exceptList = Lists.newArrayList(super.getApplicableTables());
        exceptList.remove(AORelease.class);
        return exceptList;
    }

    @Override
    protected void checkClassForRankIntegrity(Connection connection, String planId, Class<? extends ISortable> clazz) throws SQLException {
        Set<String> idsWithoutSortOrders = this.getIdsWithoutSortOrders(clazz, planId, connection);
        if (idsWithoutSortOrders.size() > 0) {
            for (String id : idsWithoutSortOrders) {
                LOGGER.warn("Found rank integrity issue: ID %s in table %s has no sort order.", id, clazz);
            }
            this.setSortOrderToZero(clazz, connection, idsWithoutSortOrders);
            LOGGER.info("Repaired sort order of broken items (set to zero).", new Object[0]);
        }
    }

    void setSortOrderToZero(final Class<? extends ISortable> clazz, Connection connection, final Set<String> idsWithoutSortOrders) throws SQLException {
        this.sql(new IUpdate(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(clazz, "t").update().tableNoAlias("t").set().colNoAlias("t", "sortOrder").eq().numeric(0).where().inNumeric(new AOQueryGenerator.InOperandCallback(){

                    @Override
                    public void generateOperand(AOQueryGenerator generator) {
                        generator.colIdNoAlias("t");
                    }
                }, idsWithoutSortOrders);
            }
        }, connection, false);
    }

    private Set<String> getIdsWithoutSortOrders(final Class<?> table, final String planId, Connection connection) throws SQLException {
        return this.sql(new IQuery<Set<String>>(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(table, "t").select().colId("t").from("t");
                RepairConfigurations.get(table).applyPlanJoin("t", generator);
                generator.where().col("t", "sortOrder").isNull().and();
                RepairConfigurations.get(table).applyPlanCondition("t", planId, generator);
            }

            @Override
            public Set<String> handleResult(ResultSet result) throws Exception {
                HashSet ids = Sets.newHashSet();
                while (result.next()) {
                    ids.add(BaseAOPersistenceSQL.getString(result, 1));
                }
                return ids;
            }
        }, connection, false);
    }
}

