/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.integrity.rank;

import com.atlassian.pocketknife.api.logging.Log;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.entities.common.ISortable;
import com.radiantminds.roadmap.common.data.integrity.DatabaseIntegrityConfiguration;
import com.radiantminds.roadmap.common.data.integrity.rank.BaseSortableIntegrityChecker;
import com.radiantminds.roadmap.common.data.integrity.rank.SortOrderExistenceIntegrityChecker;
import com.radiantminds.roadmap.common.data.integrity.rank.configurations.RepairConfigurations;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.AOWorkItem;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.AOQueryGenerator;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.BaseAOPersistenceSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.statements.IQuery;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.statements.IUpdate;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@DatabaseIntegrityConfiguration(requires={SortOrderExistenceIntegrityChecker.class})
public class SortOrderSequenceIntegrityChecker
extends BaseSortableIntegrityChecker {
    private static final Log LOGGER = Log.with(SortOrderSequenceIntegrityChecker.class);

    @Autowired
    public SortOrderSequenceIntegrityChecker(ActiveObjectsUtilities activeObjectsUtilities) {
        super(LOGGER, activeObjectsUtilities);
    }

    @Override
    protected List<Class<? extends ISortable>> getApplicableTables() {
        ArrayList exceptList = Lists.newArrayList(super.getApplicableTables());
        exceptList.add(AOWorkItem.class);
        return exceptList;
    }

    @Override
    protected void checkClassForRankIntegrity(Connection connection, String planId, Class<? extends ISortable> clazz) throws SQLException {
        Set<String> rangeIdentifiers = this.getOrderRangeIdentifiers(clazz, planId, connection);
        for (String rangeId : rangeIdentifiers) {
            LinkedHashMap<String, Long> sortedMap = this.getSortedSortOrderList(clazz, connection, rangeId);
            if (sortedMap.isEmpty()) continue;
            boolean needsFix = false;
            long first = sortedMap.values().iterator().next();
            if (first != 0L) {
                LOGGER.warn("Found rank integrity issue: First entry in range %s in table %s does not have sort order 0.", rangeId, clazz);
                needsFix = true;
            } else {
                Long last = null;
                for (Long sortOrder : sortedMap.values()) {
                    if (last != null && sortOrder != last + 1L) {
                        LOGGER.warn("Found rank integrity issue: Entry in range %s in table %s is not in sequence.", rangeId, clazz);
                        needsFix = true;
                    }
                    last = sortOrder;
                }
            }
            if (!needsFix) continue;
            LOGGER.info("Fixing sequence issues...", new Object[0]);
            this.resequence(clazz, connection, sortedMap);
            LOGGER.info("Order range %s in table %s has been resequenced.", rangeId, clazz);
        }
    }

    private void resequence(final Class<? extends ISortable> clazz, Connection connection, LinkedHashMap<String, Long> sortedMap) throws SQLException {
        int i = 0;
        for (final String id : sortedMap.keySet()) {
            final int newSortOrder = i++;
            this.sql(new IUpdate(){

                @Override
                public void sql(AOQueryGenerator generator) throws Exception {
                    generator.withTable(clazz, "t").update().tableNoAlias("t").set().colNoAlias("t", "sortOrder").eq().numeric(newSortOrder).where().colIdNoAlias("t").eq().numeric(id);
                }
            }, connection, false);
        }
    }

    private LinkedHashMap<String, Long> getSortedSortOrderList(final Class<? extends ISortable> clazz, Connection connection, final String orderRangeIdentifier) throws SQLException {
        return this.sql(new IQuery<LinkedHashMap<String, Long>>(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(clazz, "t").select().colId("t").col("t", "sortOrder").from("t").where().col("t", "orderRangeIdentifier").isNotNull().and().col("t", "sortOrder").isNotNull().and().col("t", "orderRangeIdentifier").eq().str(orderRangeIdentifier).orderBy().col("t", "sortOrder");
            }

            @Override
            public LinkedHashMap<String, Long> handleResult(ResultSet result) throws Exception {
                LinkedHashMap sortedMap = Maps.newLinkedHashMap();
                while (result.next()) {
                    sortedMap.put(BaseAOPersistenceSQL.getString(result, 1), SortOrderSequenceIntegrityChecker.getLong(result, 2));
                }
                return sortedMap;
            }
        }, connection, false);
    }

    private Set<String> getOrderRangeIdentifiers(final Class<? extends ISortable> clazz, final String planId, Connection connection) throws SQLException {
        return this.sql(new IQuery<Set<String>>(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(clazz, "t").select().distinct().col("t", "orderRangeIdentifier").from("t");
                RepairConfigurations.get(clazz).applyPlanJoin("t", generator);
                generator.where();
                RepairConfigurations.get(clazz).applyPlanCondition("t", planId, generator);
            }

            @Override
            public Set<String> handleResult(ResultSet result) throws Exception {
                HashSet ids = Sets.newHashSet();
                while (result.next()) {
                    ids.add(BaseAOPersistenceSQL.getString(result, 1));
                }
                return ids;
            }
        }, connection, false);
    }
}

