/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao;

import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.entities.common.IIdentifiable;
import com.radiantminds.roadmap.common.data.persistence.PersistenceException;
import com.radiantminds.roadmap.common.data.persistence.ao.common.AOIdentifiable;
import com.radiantminds.roadmap.common.data.persistence.ao.common.AOTransformer;
import com.radiantminds.roadmap.common.data.persistence.ao.port.IKeyResolver;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.AOQueryGenerator;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.CommonSQL;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.EntityInfo;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.IEntityPersistence;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;

public abstract class AOEntityPersistence<TEntityInterface extends IIdentifiable, TAOInterface extends AOIdentifiable>
implements IEntityPersistence<TEntityInterface> {
    private final ActiveObjectsUtilities utils;
    private final Class<TEntityInterface> entityClazz;
    private final Class<TAOInterface> aoClazz;
    private final CommonSQL commonSQL;

    public AOEntityPersistence(ActiveObjectsUtilities utils, Class<TEntityInterface> entityClazz, Class<TAOInterface> aoClazz) {
        this.utils = utils;
        this.entityClazz = entityClazz;
        this.aoClazz = aoClazz;
        this.commonSQL = new CommonSQL(utils);
    }

    protected abstract void transform(TEntityInterface var1, TAOInterface var2) throws Exception;

    @Override
    public void onAfterCreate(TEntityInterface entity) throws PersistenceException {
    }

    protected void onBeforeCreate(TEntityInterface entity) throws PersistenceException {
    }

    @Override
    public EntityInfo getEntityInfo(String id) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<EntityInfo> getEntityInfos(Collection<String> ids) throws SQLException {
        throw new UnsupportedOperationException();
    }

    protected ActiveObjectsUtilities getUtils() {
        return this.utils;
    }

    protected Class<TAOInterface> getAoClazz() {
        return this.aoClazz;
    }

    @Override
    public Class<TEntityInterface> getEntityClass() {
        return this.entityClazz;
    }

    @Override
    public Class<?> getDbInterfaceClass() {
        return this.aoClazz;
    }

    @Override
    public Class<? extends IEntityPersistence> getPersistenceType() {
        return IEntityPersistence.class;
    }

    @Override
    public TEntityInterface get(String id) throws PersistenceException {
        Object retVal = this.utils.get(this.aoClazz, id);
        return (TEntityInterface)retVal;
    }

    @Override
    public TEntityInterface persist(TEntityInterface entity) throws PersistenceException {
        return this.persistInternal(entity, true, false);
    }

    @Override
    public TEntityInterface persistSilent(TEntityInterface entity) throws PersistenceException {
        return this.persistInternal(entity, true, true);
    }

    @Override
    public TEntityInterface persist(TEntityInterface entity, boolean incrementVersions) throws PersistenceException {
        return this.persistInternal(entity, incrementVersions, false);
    }

    private TEntityInterface persistInternal(TEntityInterface entity, boolean incrementVersions, boolean silent) throws PersistenceException {
        Long now = System.currentTimeMillis();
        if (entity != null && incrementVersions) {
            Long version = entity.getVersion() != null ? entity.getVersion() + 1L : 0L;
            entity.setVersion(version);
        }
        Long versioning = System.currentTimeMillis() - now;
        now = System.currentTimeMillis();
        if (entity != null && entity.getId() == null) {
            this.onBeforeCreate(entity);
        }
        Long onBefCreate = System.currentTimeMillis() - now;
        now = System.currentTimeMillis();
        TEntityInterface retVal = this.utils.persist(this.entityClazz, this.aoClazz, entity, new AOTransformer<TEntityInterface, TAOInterface>(){

            @Override
            public void copyValues(TEntityInterface source, TAOInterface target) throws Exception {
                AOEntityPersistence.this.transform(source, target);
            }
        }, silent);
        Long persist = System.currentTimeMillis() - now;
        now = System.currentTimeMillis();
        if (entity != null && entity.getId() == null) {
            this.onAfterCreate(retVal);
        }
        Long onAftCreate = System.currentTimeMillis() - now;
        now = System.currentTimeMillis();
        Long total = versioning + onBefCreate + persist + onAftCreate;
        return retVal;
    }

    @Override
    public boolean delete(String id, boolean inCascade) throws PersistenceException {
        boolean retVal = this.utils.delete(this.entityClazz, this.aoClazz, id);
        return retVal;
    }

    @Override
    public List<TEntityInterface> list() throws PersistenceException {
        List retVal = this.utils.find(this.aoClazz);
        return retVal;
    }

    @Override
    public Long incrementVersion(String id) throws SQLException {
        this.commonSQL.incrementVersion(this.aoClazz, id);
        return this.commonSQL.getVersion(this.aoClazz, id);
    }

    @Override
    public Long getVersion(String id) throws SQLException {
        return this.commonSQL.getVersion(this.aoClazz, id);
    }

    @Override
    public boolean exists(String id) throws SQLException {
        return this.commonSQL.exists(this.aoClazz, id);
    }

    @Override
    public List<String> existingSubset(List<String> ids) throws SQLException {
        if (ids == null) {
            return null;
        }
        return this.commonSQL.existingSubset(this.aoClazz, ids);
    }

    @Override
    public IKeyResolver getForeignKeyResolver(String method) {
        throw new RuntimeException("Foreign key resolver not implemented for '" + this.aoClazz.getSimpleName() + "'::'" + method + "'.");
    }

    @Override
    public void getRowCountQueryForPlan(AOQueryGenerator generator, String planId) throws SQLException {
        this.selectAllForPlan(generator, planId, false);
        generator.replace("DISTINCT", "");
        generator.replace("SELECT (\\w\\.)?\\*", "SELECT COUNT(*)");
    }
}

