/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.entities.configuration;

import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.entities.configuration.ICustomWording;
import com.radiantminds.roadmap.common.data.persistence.ao.AOEntityPersistence;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.configuration.AOCustomWording;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.configuration.sql.CustomWordingSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.configuration.sql.CustomWordingStoreSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.AOQueryGenerator;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.IEntityPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioCustomWordingPersistence;
import java.sql.SQLException;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PortfolioActiveObjectsCustomWordingPersistence
extends AOEntityPersistence<ICustomWording, AOCustomWording>
implements PortfolioCustomWordingPersistence {
    private final CustomWordingSQL customWordingSQL;
    private final CustomWordingStoreSQL customWordingStoreSQL;

    @Autowired
    public PortfolioActiveObjectsCustomWordingPersistence(ActiveObjectsUtilities utils) {
        super(utils, ICustomWording.class, AOCustomWording.class);
        this.customWordingSQL = new CustomWordingSQL(utils);
        this.customWordingStoreSQL = new CustomWordingStoreSQL(utils);
    }

    @Override
    protected void transform(ICustomWording source, AOCustomWording target) throws Exception {
        target.setWordKey(source.getWordValue());
        target.setVersion(source.getVersion());
    }

    @Override
    public Class<? extends IEntityPersistence> getPersistenceType() {
        return PortfolioCustomWordingPersistence.class;
    }

    @Override
    public void selectAllForPlan(AOQueryGenerator generator, String planId, boolean inOrder) throws SQLException {
        throw new RuntimeException("Not implemented for CustomWording. Should not be used for import/export!");
    }

    @Override
    public void store(String key, String value) throws SQLException {
        this.customWordingStoreSQL.store(key, value);
    }

    @Override
    public void remove(String key) throws SQLException {
        this.customWordingSQL.remove(key);
    }

    @Override
    public Map<String, String> getCustomWordings() throws SQLException {
        return this.customWordingSQL.getCustomWordings();
    }
}

