/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.entities.permissions;

import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.entities.permissions.IPermission;
import com.radiantminds.roadmap.common.data.persistence.PersistenceException;
import com.radiantminds.roadmap.common.data.persistence.ao.AOEntityPersistence;
import com.radiantminds.roadmap.common.data.persistence.ao.common.TransformerUtils;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.permissions.AOPermission;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.permissions.sql.PermissionSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.plans.AOPlan;
import com.radiantminds.roadmap.common.data.persistence.ao.port.IKeyResolver;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.AOQueryGenerator;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.IEntityPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioPermissionPersistence;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PortfolioActiveObjectsPermissionPersistence
extends AOEntityPersistence<IPermission, AOPermission>
implements PortfolioPermissionPersistence {
    private final PermissionSQL permissionSQL;

    @Autowired
    public PortfolioActiveObjectsPermissionPersistence(ActiveObjectsUtilities utils) {
        super(utils, IPermission.class, AOPermission.class);
        this.permissionSQL = new PermissionSQL(utils);
    }

    @Override
    public Class<? extends IEntityPersistence> getPersistenceType() {
        return PortfolioPermissionPersistence.class;
    }

    @Override
    protected void transform(IPermission source, AOPermission target) throws Exception {
        TransformerUtils.transformVersionable(source, target);
        target.setHolderId(source.getHolderId());
        target.setHolderType(source.getHolderType());
        target.setPermission(source.getPermission());
        target.setTargetId(source.getTargetId());
        target.setTargetType(source.getTargetType());
    }

    @Override
    public List<IPermission> getPermissionsCached(String targetType, String targetId) throws SQLException {
        return this.permissionSQL.getPermissions(targetType, targetId);
    }

    @Override
    public boolean deleteCached(String id) throws PersistenceException {
        return this.delete(id, false);
    }

    @Override
    public IPermission persistCached(IPermission entity) throws PersistenceException {
        return this.persist(entity);
    }

    @Override
    public boolean exists(IPermission permission) throws SQLException {
        return this.permissionSQL.exists(permission);
    }

    @Override
    public Boolean testPluginPermissions(Collection<String> targetIds, String userId, Collection<String> userGroupIds) throws SQLException {
        return this.permissionSQL.testPluginPermissions(targetIds, userId, userGroupIds);
    }

    @Override
    public void selectAllForPlan(AOQueryGenerator generator, String planId, boolean inOrder) throws SQLException {
        generator.withTable(AOPermission.class, "m").select().raw("*").from("m").where().col("m", "targetType").eq().str("plan").and().col("m", "targetId").eq().str(planId);
        if (inOrder) {
            generator.orderBy().colId("m");
        }
    }

    @Override
    public IKeyResolver getForeignKeyResolver(String method) {
        if ("getTargetId".equals(method)) {
            return new PermissionTargetForeignKeyResolver();
        }
        return super.getForeignKeyResolver(method);
    }

    private class PermissionTargetForeignKeyResolver
    implements IKeyResolver {
        private PermissionTargetForeignKeyResolver() {
        }

        @Override
        public Class<?> resolve(String dependency) {
            if ("plan".equals(dependency)) {
                return AOPlan.class;
            }
            throw new RuntimeException("Cannot create foreign key resolver for permission target type '" + dependency + "'. Should not be returned by query!");
        }

        @Override
        public String getPrefix(String dependency) {
            return null;
        }
    }
}

