/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.entities.releases;

import com.google.common.collect.Lists;
import com.radiantminds.roadmap.common.data.entities.plans.IPlan;
import com.radiantminds.roadmap.common.data.entities.releases.IRelease;
import com.radiantminds.roadmap.common.data.persistence.ao.common.AOIdentifiableImpl;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.plans.AOPlan;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.releases.AORelease;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.releases.AOStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class AOStreamImpl
extends AOIdentifiableImpl {
    private final AOStream data;

    public AOStreamImpl(AOStream data) {
        super(data);
        this.data = data;
    }

    public List<IRelease> getReleases() {
        ArrayList retVal = Lists.newArrayList();
        for (AORelease release : this.data.getAOReleases()) {
            if (release.getIsLaterRelease() != null && release.getIsLaterRelease().booleanValue()) continue;
            retVal.add(release);
        }
        return retVal;
    }

    public IRelease getLaterRelease() {
        for (AORelease release : this.data.getAOReleases()) {
            if (release.getIsLaterRelease() == null || !release.getIsLaterRelease().booleanValue()) continue;
            return release;
        }
        return null;
    }

    public IPlan getPlan() {
        return this.data.getAOPlan();
    }

    public void setPlan(IPlan plan) {
        this.setExplicitRelation(plan, AOPlan.class, new AOIdentifiableImpl.IRelationCallback<AOPlan>(){

            @Override
            public void apply(AOPlan relation) {
                AOStreamImpl.this.data.setOrderRangeIdentifier("plan-" + relation.getId());
                AOStreamImpl.this.data.setAOPlan(relation);
            }
        });
    }

    public Set<String> getTeams() {
        throw new RuntimeException("Use streamPersistence.getRestrictedTeamIds instead");
    }
}

