/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.entities.releases.sql;

import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.releases.AORelease;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.AOQueryGenerator;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.BaseAOPersistenceSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.statements.IQuery;
import java.sql.ResultSet;
import java.sql.SQLException;

public class StreamToReleaseSQL
extends BaseAOPersistenceSQL {
    public StreamToReleaseSQL(ActiveObjectsUtilities utils) {
        super(utils);
    }

    public boolean validateAssignment(final String streamId, final String releaseId) throws SQLException {
        return this.sql(new IQuery<Boolean>(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AORelease.class, "r").select().col("r", "aoStream").from("r").where().colId("r").eq().numeric(releaseId);
            }

            @Override
            public Boolean handleResult(ResultSet result) throws Exception {
                if (result.next() && BaseAOPersistenceSQL.getString(result, 1).equals(streamId)) {
                    return true;
                }
                return false;
            }
        });
    }
}

