/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.entities.replanning;

import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.persistence.ao.AOEntityPersistence;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.people.AOTeam;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.releases.AORelease;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.releases.AOStream;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.replanning.AOReplanning;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.AOWorkItem;
import com.radiantminds.roadmap.common.data.persistence.ao.port.IKeyResolver;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.AOQueryGenerator;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.IEntityPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioReplanningPersistence;
import java.sql.SQLException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PortfolioActiveObjectsReplanningPersistence
extends AOEntityPersistence<AOReplanning, AOReplanning>
implements PortfolioReplanningPersistence {
    @Autowired
    public PortfolioActiveObjectsReplanningPersistence(ActiveObjectsUtilities utils) {
        super(utils, AOReplanning.class, AOReplanning.class);
    }

    @Override
    public Class<? extends IEntityPersistence> getPersistenceType() {
        return PortfolioReplanningPersistence.class;
    }

    @Override
    protected void transform(AOReplanning source, AOReplanning target) throws Exception {
        throw new RuntimeException("Not available on this persistence.");
    }

    @Override
    public void selectAllForPlan(AOQueryGenerator generator, String planId, boolean inOrder) throws SQLException {
        generator.withTable(AOReplanning.class, "t").withTable(AOWorkItem.class, "h1").select().raw("t.*").from("t").leftJoin().table("h1").on().col("t", "workitem").eq().colId("h1").where().col("h1", "aoplan").eq().numeric(planId);
        if (inOrder) {
            generator.orderBy().colId("t");
        }
    }

    @Override
    public IKeyResolver getForeignKeyResolver(String method) {
        if ("getTargetId".equals(method)) {
            return new ReplanningForeignKeyResolver();
        }
        return super.getForeignKeyResolver(method);
    }

    private class ReplanningForeignKeyResolver
    implements IKeyResolver {
        private ReplanningForeignKeyResolver() {
        }

        @Override
        public Class<?> resolve(String dependency) {
            if ("team".equals(dependency)) {
                return AOTeam.class;
            }
            if ("release".equals(dependency)) {
                return AORelease.class;
            }
            if ("stream".equals(dependency)) {
                return AOStream.class;
            }
            throw new RuntimeException("Cannot create foreign key resolver for replanning target type '" + dependency + "'.");
        }

        @Override
        public String getPrefix(String dependency) {
            return null;
        }
    }
}

