/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.entities.themes;

import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.entities.plans.IPlan;
import com.radiantminds.roadmap.common.data.entities.themes.ITheme;
import com.radiantminds.roadmap.common.data.persistence.PersistenceException;
import com.radiantminds.roadmap.common.data.persistence.ao.AOSortableEntityPersistence;
import com.radiantminds.roadmap.common.data.persistence.ao.common.TransformerUtils;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.common.sql.EntityInfoSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.themes.AOTheme;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.themes.sql.ThemeSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.AOQueryGenerator;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.EntityInfo;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.IEntityPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioThemePersistence;
import com.radiantminds.roadmap.common.data.persistence.services.PortfolioPlanPersistence;
import java.sql.SQLException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PortfolioActiveObjectsThemePersistence
extends AOSortableEntityPersistence<ITheme, AOTheme>
implements PortfolioThemePersistence {
    private final ThemeSQL themeSQL;
    private final EntityInfoSQL entityInfoSQL;
    private final PortfolioPlanPersistence planPersistence;

    @Autowired
    public PortfolioActiveObjectsThemePersistence(ActiveObjectsUtilities utils, PortfolioPlanPersistence planPersistence) {
        super(utils, ITheme.class, AOTheme.class);
        this.planPersistence = planPersistence;
        this.themeSQL = new ThemeSQL(utils);
        this.entityInfoSQL = new EntityInfoSQL(utils);
    }

    @Override
    public Class<? extends IEntityPersistence> getPersistenceType() {
        return PortfolioThemePersistence.class;
    }

    @Override
    protected void transform(ITheme source, AOTheme target) throws Exception {
        TransformerUtils.transformDescribable(source, target);
        TransformerUtils.transformSortable(source, target);
        target.setColor(source.getColor());
        target.setPercentage(source.getPercentage());
        if (source.getPlan() != null) {
            target.setPlan((IPlan)this.planPersistence.get(source.getPlan().getId()));
        }
    }

    @Override
    public List<ITheme> listCustom(String planId) throws PersistenceException, SQLException {
        return this.themeSQL.getThemes(planId);
    }

    @Override
    public EntityInfo getEntityInfo(String themeId) throws SQLException {
        return this.entityInfoSQL.getEntityInfo(themeId, AOTheme.class, new EntityInfoSQL.ParentRelationship[0]);
    }

    @Override
    public void selectAllForPlan(AOQueryGenerator generator, String planId, boolean inOrder) throws SQLException {
        generator.withTable(AOTheme.class, "t").select().raw("*").from("t").where().col("t", "aoplan").eq().numeric(planId);
        if (inOrder) {
            generator.orderBy().col("t", "sortOrder");
        }
    }
}

