/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.estimate;

import com.google.common.base.Optional;
import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.common.DataMode;
import com.radiantminds.roadmap.common.data.entities.workitems.IEstimate;
import com.radiantminds.roadmap.common.data.entities.workitems.IEstimateBlock;
import com.radiantminds.roadmap.common.data.persistence.ao.AOEntityPersistence;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.skills.AOSkill;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.skills.AOStage;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.estimate.AOEstimate;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.estimate.sql.EstimateSelectSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.estimate.sql.EstimateUpdateSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.AOWorkItem;
import com.radiantminds.roadmap.common.data.persistence.ao.port.IKeyResolver;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.AOQueryGenerator;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.IEntityPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioEstimatePersistence;
import com.radiantminds.roadmap.common.rest.entities.workitems.RestEstimateBlock;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PortfolioActiveObjectsEstimatePersistence
extends AOEntityPersistence<IEstimate, AOEstimate>
implements PortfolioEstimatePersistence {
    private final EstimateSelectSQL estimateSelectSQL;
    private final EstimateUpdateSQL estimateUpdateSQL;

    @Autowired
    public PortfolioActiveObjectsEstimatePersistence(ActiveObjectsUtilities utils) {
        super(utils, IEstimate.class, AOEstimate.class);
        this.estimateSelectSQL = new EstimateSelectSQL(utils);
        this.estimateUpdateSQL = new EstimateUpdateSQL(utils);
    }

    @Override
    public Class<? extends IEntityPersistence> getPersistenceType() {
        return PortfolioEstimatePersistence.class;
    }

    @Override
    protected void transform(IEstimate source, AOEstimate target) throws Exception {
        target.setCurrency(source.getCurrency());
        target.setEstimate(source.getEstimate());
        target.setReplanning(source.getReplanning());
        target.setOriginal(source.getOriginal());
        target.setWorkItem(source.getWorkItem());
    }

    @Override
    public List<IEstimate> getAllEstimates(String id, DataMode dataMode) throws Exception {
        return this.estimateSelectSQL.getAllEstimates(id, dataMode);
    }

    @Override
    public void setTotalEstimate(String id, IEstimate estimate, DataMode dataMode) throws Exception {
        this.estimateUpdateSQL.setEstimate(id, "total", null, dataMode, estimate);
    }

    @Override
    public Optional<IEstimate> getTotalEstimate(String id, DataMode dataMode) throws Exception {
        return this.estimateSelectSQL.getTotalEstimate(id, dataMode);
    }

    @Override
    public void setStageEstimate(String id, String stageId, IEstimate estimate, DataMode dataMode) throws Exception {
        this.estimateUpdateSQL.setEstimate(id, "stage", stageId, dataMode, estimate);
    }

    @Override
    public List<IEstimate> getStageEstimates(String id, DataMode dataMode) throws Exception {
        return this.estimateSelectSQL.getEstimatesOfType(id, "stage", dataMode);
    }

    @Override
    public void setSkillEstimate(String id, String skillId, IEstimate estimate, DataMode dataMode) throws Exception {
        this.estimateUpdateSQL.setEstimate(id, "skill", skillId, dataMode, estimate);
    }

    @Override
    public List<IEstimate> getSkillEstimates(String id, DataMode dataMode) throws Exception {
        return this.estimateSelectSQL.getEstimatesOfType(id, "skill", dataMode);
    }

    @Override
    public void clearEstimates(String workItemId) throws SQLException {
        this.estimateUpdateSQL.clearEstimates(workItemId);
    }

    @Override
    public void clearEstimatesForTarget(String targetType, String targetId) throws SQLException {
        this.estimateUpdateSQL.clearEstimatesForTarget(targetType, targetId);
    }

    @Override
    public void clearReplanningEstimates(String workItemId) throws Exception {
        this.estimateUpdateSQL.clearReplanningEstimates(workItemId);
    }

    @Override
    public void clearReplanningEstimatesBulk(List<String> workItemIds) throws Exception {
        this.estimateUpdateSQL.clearReplanningEstimatesBulk(workItemIds);
    }

    @Override
    public void clearOriginalEstimates(String workItemId) throws Exception {
        this.estimateUpdateSQL.clearOriginalEstimates(workItemId);
    }

    @Override
    public void copyCurrentToOriginalEstimates(String workItemId, Optional<Double> defaultEstimate, boolean overwrite) throws Exception {
        this.estimateUpdateSQL.copyCurrentToOriginalEstimates(workItemId, defaultEstimate, overwrite);
    }

    @Override
    public void applyReplanning(String workItemId, Long replanningDate) throws Exception {
        for (IEstimate estimate : this.getAllEstimates(workItemId, DataMode.Replanning)) {
            String targetId = estimate.getTargetId() != null ? String.valueOf(estimate.getTargetId()) : null;
            this.estimateUpdateSQL.setEstimate(workItemId, estimate.getTargetType(), targetId, DataMode.Default, estimate);
        }
    }

    @Override
    public boolean hasOriginalEstimates(String workItemId) throws Exception {
        return this.estimateUpdateSQL.hasOriginalEstimates(workItemId);
    }

    @Override
    public IEstimateBlock getCurrentEstimates(String workItemId) throws Exception {
        RestEstimateBlock block = new RestEstimateBlock();
        block.setTotal((IEstimate)this.getTotalEstimate(workItemId, DataMode.Default).orNull());
        block.setStages(this.getStageEstimates(workItemId, DataMode.Default));
        block.setSkills(this.getSkillEstimates(workItemId, DataMode.Default));
        return block;
    }

    @Override
    public IEstimateBlock getOriginalEstimates(String workItemId) throws Exception {
        RestEstimateBlock block = new RestEstimateBlock();
        block.setTotal((IEstimate)this.getTotalEstimate(workItemId, DataMode.Original).orNull());
        block.setStages(this.getStageEstimates(workItemId, DataMode.Original));
        block.setSkills(this.getSkillEstimates(workItemId, DataMode.Original));
        return block;
    }

    @Override
    public IEstimateBlock getReplanningEstimates(String workItemId) throws Exception {
        RestEstimateBlock block = new RestEstimateBlock();
        block.setTotal((IEstimate)this.getTotalEstimate(workItemId, DataMode.Replanning).orNull());
        block.setStages(this.getStageEstimates(workItemId, DataMode.Replanning));
        block.setSkills(this.getSkillEstimates(workItemId, DataMode.Replanning));
        return block;
    }

    @Override
    public Map<String, Map<DataMode, IEstimateBlock>> getRemainingAndOriginalEstimates(Collection<String> workItemIDs) throws SQLException {
        return this.estimateSelectSQL.getRemainingAndOriginalEstimates(workItemIDs);
    }

    @Override
    public void selectAllForPlan(AOQueryGenerator generator, String planId, boolean inOrder) throws SQLException {
        generator.withTable(AOEstimate.class, "e").withTable(AOWorkItem.class, "w").select().raw("e.*").from("e").leftJoin().table("w").on().col("e", "aoworkitem").eq().colId("w").where().col("w", "aoplan").eq().numeric(planId);
        if (inOrder) {
            generator.orderBy().colId("e");
        }
    }

    @Override
    public IKeyResolver getForeignKeyResolver(String method) {
        if ("getTargetId".equals(method)) {
            return new EstimateTargetForeignKeyResolver();
        }
        return super.getForeignKeyResolver(method);
    }

    private class EstimateTargetForeignKeyResolver
    implements IKeyResolver {
        private EstimateTargetForeignKeyResolver() {
        }

        @Override
        public Class<?> resolve(String dependency) {
            if (dependency == null) {
                return null;
            }
            if ("skill".equals(dependency)) {
                return AOSkill.class;
            }
            if ("stage".equals(dependency)) {
                return AOStage.class;
            }
            throw new RuntimeException("Cannot create foreign key resolver for estimation target type '" + dependency + "'.");
        }

        @Override
        public String getPrefix(String dependency) {
            return null;
        }
    }
}

