/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem;

import com.radiantminds.roadmap.common.data.entities.workitems.WorkItems;
import com.radiantminds.roadmap.common.data.persistence.ao.port.PrefixedAnonymisationProvider;
import java.util.Map;

public class WorkItemAnonymisationProvider
extends PrefixedAnonymisationProvider {
    private int initiativeCount = 1;
    private int epicCount = 1;
    private int storyCount = 1;
    private int unknownCount = 1;

    public WorkItemAnonymisationProvider() {
        super("Workitem");
    }

    @Override
    public String anonymise(Map<String, String> originalValues) {
        String type = originalValues.get("type");
        try {
            int intType = Integer.parseInt(type);
            if (WorkItems.Types.INITIATIVE.equals(intType)) {
                return "Initiative" + this.initiativeCount++;
            }
            if (WorkItems.Types.EPIC.equals(intType)) {
                return "Epic " + this.epicCount++;
            }
            if (WorkItems.Types.STORY.equals(intType)) {
                return "Story " + this.storyCount++;
            }
            return "Unknown Type " + this.unknownCount++;
        }
        catch (Exception exception) {
            return super.anonymise(originalValues);
        }
    }
}

