/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.sql;

import com.google.common.collect.Maps;
import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.entities.workitems.WorkItems;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.AOWorkItem;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.AOQueryGenerator;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.BaseAOPersistenceSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.statements.IQuery;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class WorkItemHierarchySQL
extends BaseAOPersistenceSQL {
    public WorkItemHierarchySQL(ActiveObjectsUtilities activeObjectsUtilities) {
        super(activeObjectsUtilities);
    }

    public Map<String, String> getAllWorkItemsWithParentRelation(final String planId) throws SQLException {
        return this.sql(new IQuery<Map<String, String>>(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOWorkItem.class, "w").select().colId("w").col("w", "aoParent").col("w", "type").from("w").where().col("w", "aoPlan").eq().numeric(planId);
            }

            @Override
            public Map<String, String> handleResult(ResultSet result) throws Exception {
                HashMap retVal = Maps.newHashMap();
                while (result.next()) {
                    String id = BaseAOPersistenceSQL.getString(result, 1);
                    String parent = BaseAOPersistenceSQL.getString(result, 2);
                    Integer type = BaseAOPersistenceSQL.getInt(result, 3);
                    if (!WorkItems.Types.INITIATIVE.equals(type) && parent == null) {
                        parent = "-1";
                    }
                    retVal.put(id, parent);
                }
                return retVal;
            }
        });
    }
}

