/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.sql;

import com.google.common.collect.Lists;
import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.releases.AORelease;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.replanning.AOReplanning;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.AOWorkItem;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.AOQueryGenerator;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.BaseAOPersistenceSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.statements.IQuery;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.statements.IUpdate;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class WorkItemReplanningSQL
extends BaseAOPersistenceSQL {
    public WorkItemReplanningSQL(ActiveObjectsUtilities activeObjectsUtilities) {
        super(activeObjectsUtilities);
    }

    public void cascadeReplanningStreamOnReleaseDeletion(final String releaseId) throws SQLException {
        final List<String> affectedWorkItems = this.sql(new IQuery<List<String>>(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOWorkItem.class, "w").withTable(AOReplanning.class, "r").withTable(AORelease.class, "e").select().colId("w").from("w").leftJoin().table("r").on().colId("w").eq().col("r", "workitem").and().col("r", "targetType").eq().str("stream").where().col("w", "aostream").eq().raw("(").select().col("e", "aostream").from("e").where().colId("e").eq().numeric(releaseId).raw(")").and().col("w", "aostream").eq().colAsInt("r", "targetId").and().col("w", "aorelease").isNull();
            }

            @Override
            public List<String> handleResult(ResultSet result) throws Exception {
                ArrayList workItemIds = Lists.newArrayList();
                while (result.next()) {
                    workItemIds.add(BaseAOPersistenceSQL.getString(result, 1));
                }
                return workItemIds;
            }
        });
        if (affectedWorkItems.size() > 0) {
            this.sql(new IUpdate(){

                @Override
                public void sql(AOQueryGenerator generator) throws Exception {
                    generator.withTable(AOReplanning.class, "r").deleteFrom().tableNoAlias("r").where().inNumeric(new AOQueryGenerator.InOperandCallback(){

                        @Override
                        public void generateOperand(AOQueryGenerator generator) {
                            generator.colNoAlias("r", "workitem");
                        }
                    }, affectedWorkItems).and().colNoAlias("r", "targetType").eq().str("stream");
                }
            });
        }
    }
}

