/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.sql;

import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.AOWorkItem;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.AOQueryGenerator;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.BaseAOPersistenceSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.statements.IQuery;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.statements.IUpdate;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioWorkItemPersistence;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.math3.util.Pair;

public class WorkItemStreamSQL
extends BaseAOPersistenceSQL {
    private final PortfolioWorkItemPersistence workItemPersistence;

    public WorkItemStreamSQL(ActiveObjectsUtilities activeObjectsUtilities, PortfolioWorkItemPersistence workItemPersistence) {
        super(activeObjectsUtilities);
        this.workItemPersistence = workItemPersistence;
    }

    public void moveWorkItemsToStream(final String from, final String to) throws SQLException {
        this.sql(new IUpdate(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOWorkItem.class, "w").update().tableNoAlias("w").set().colNoAlias("w", "aoRelease").eq().nullValue().raw(",").colNoAlias("w", "aoStream").eq().numeric(to).where().colNoAlias("w", "aoStream").eq().numeric(from);
            }
        });
    }

    public void reactToChildDeletion(final String workItem) throws SQLException {
        Pair<String, String> parentIdToChildStreamId = this.sql(new IQuery<Pair<String, String>>(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOWorkItem.class, "w").withTable(AOWorkItem.class, "i").select().col("w", "aoparent").col("w", "aoStream").from("w").where().colId("w").eq().numeric(workItem).and().raw("(").select().raw("count(*)").from("i").where().col("i", "aoparent").eq().col("w", "aoparent").raw(")").eq().numeric(1);
            }

            @Override
            public Pair<String, String> handleResult(ResultSet result) throws Exception {
                if (result.next()) {
                    return new Pair<String, String>(BaseAOPersistenceSQL.getString(result, 1), BaseAOPersistenceSQL.getString(result, 2));
                }
                return null;
            }
        });
        if (parentIdToChildStreamId != null) {
            this.workItemPersistence.setStream(parentIdToChildStreamId.getFirst(), parentIdToChildStreamId.getSecond());
        }
    }
}

