/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.sql.select;

import com.atlassian.pocketknife.api.logging.Log;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.sql.select.EstimateTableHelper;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.sql.select.EstimationDataBlock;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.sql.select.EstimationDataBlockReader;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.sql.select.ReplanningRelationsDataBlock;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.sql.select.ReplanningRelationsDataBlockReader;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.sql.select.ResultSetParsingUtils;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.sql.select.StructuredQueryDataTree;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.sql.select.WorkItemDataBlock;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.sql.select.WorkItemQueryRowData;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.sql.select.WorkItemRowDataReader;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.sql.select.WorkItemTableHelper;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.Immutable;

@Immutable
class ResultSetReader {
    private static final Log LOGGER = Log.with(ResultSetReader.class);
    private final WorkItemRowDataReader workItemRowDataReader;
    private final EstimationDataBlockReader estmationRowDataReader;
    private final ReplanningRelationsDataBlockReader replanningRelationsDataBlockReader;

    ResultSetReader() {
        this(new WorkItemRowDataReader(), new EstimationDataBlockReader(), new ReplanningRelationsDataBlockReader());
    }

    ResultSetReader(WorkItemRowDataReader workItemRowDataReader, EstimationDataBlockReader estmationRowDataReader, ReplanningRelationsDataBlockReader replanningRelationsDataBlockReader) {
        this.workItemRowDataReader = workItemRowDataReader;
        this.estmationRowDataReader = estmationRowDataReader;
        this.replanningRelationsDataBlockReader = replanningRelationsDataBlockReader;
    }

    StructuredQueryDataTree readResultSet(ResultSet resultSet, boolean includeReplanning) throws SQLException {
        LOGGER.debug("read result set %s , including replanning: %s", resultSet, includeReplanning);
        int levels = ResultSetParsingUtils.calculateLevels(resultSet, includeReplanning);
        ArrayList rowData = Lists.newArrayList();
        HashMap workItemDataBlocks = Maps.newHashMap();
        while (resultSet.next()) {
            WorkItemQueryRowData row = this.parserNextLine(resultSet, levels, includeReplanning, workItemDataBlocks);
            rowData.add(row);
        }
        StructuredQueryDataTree queryData = StructuredQueryDataTree.createInstance(rowData);
        LOGGER.debug("read data: %s", queryData);
        return queryData;
    }

    public WorkItemQueryRowData parserNextLine(ResultSet resultSet, int levels, boolean includeReplanning, Map<String, WorkItemDataBlock> workItemDataBlocks) throws SQLException {
        List<WorkItemDataBlock> workItemData = this.workItemRowDataReader.readRowData(resultSet, levels, includeReplanning, workItemDataBlocks);
        int estimationOffset = WorkItemTableHelper.getColumnSelectCount(includeReplanning) * levels;
        Optional<EstimationDataBlock> estimationData = this.estmationRowDataReader.readRowData(resultSet, estimationOffset);
        ReplanningRelationsDataBlock replanningRelationsDataBlock = null;
        if (includeReplanning) {
            int replanningOffset = estimationOffset + EstimateTableHelper.getColumnSelectCount();
            replanningRelationsDataBlock = this.replanningRelationsDataBlockReader.readRowData(resultSet, replanningOffset);
        }
        WorkItemQueryRowData rowData = new WorkItemQueryRowData(workItemData, (EstimationDataBlock)estimationData.orNull(), replanningRelationsDataBlock);
        return rowData;
    }
}

