/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.sql.select;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.entities.workitems.IWorkItem;
import com.radiantminds.roadmap.common.data.entities.workitems.WorkItemStatus;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.replanning.AOReplanning;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.estimate.AOEstimate;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.AOWorkItem;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.sql.select.EstimateTableHelper;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.sql.select.FilterHelper;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.sql.select.OrderByHelper;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.sql.select.ReplanningTableHelper;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.sql.select.WorkItemSelectQueryParser;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.sql.select.WorkItemTableHelper;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.AOQueryGenerator;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.BaseAOPersistenceSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.statements.IQuery;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioResourcePersistence;
import com.radiantminds.roadmap.common.extensions.workitems.ProgressConfiguration;
import com.radiantminds.roadmap.common.extensions.workitems.WorkItemExtension;
import com.radiantminds.roadmap.common.filter.IWorkItemFilter;
import com.radiantminds.roadmap.common.filter.WorkItemSolutionFilterResult;
import com.radiantminds.roadmap.common.stats.MonitoredCallResult;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;

public class WorkItemSelectQueryBuilder
extends BaseAOPersistenceSQL {
    public static final int DEFAULT_WORK_ITEM_RELATION_DEPTH = 3;
    private static final String TABLE_ESTIMATE = "estimate";
    static final Map<String, String> replanningRelations = Maps.newLinkedHashMap();
    private final List<String> workItemLevels = Lists.newArrayList();
    private final WorkItemSelectQueryParser parser;
    private String planId;
    private boolean includeReplanning = false;
    private boolean includeDone = false;
    private boolean includeDoneDependencies = false;
    private boolean enrichWithExtensions = false;
    private ProgressConfiguration progressConfiguration = null;
    private List<String> idRange;
    private IWorkItemFilter filter;
    private WorkItemSolutionFilterResult solutionFilterResult;

    protected WorkItemSelectQueryBuilder(ActiveObjectsUtilities activeObjectsUtilities, PortfolioResourcePersistence resourcePersistence, WorkItemExtension workItemExtension) {
        super(activeObjectsUtilities);
        this.parser = new WorkItemSelectQueryParser(activeObjectsUtilities, resourcePersistence, workItemExtension);
    }

    public boolean isEnrichWithExtensions() {
        return this.enrichWithExtensions;
    }

    public static WorkItemSelectQueryBuilder create(ActiveObjectsUtilities activeObjectsUtilities, PortfolioResourcePersistence resourcePersistence, WorkItemExtension workItemExtension) {
        return new WorkItemSelectQueryBuilder(activeObjectsUtilities, resourcePersistence, workItemExtension);
    }

    public WorkItemSelectQueryBuilder withWorkItemRelationDepth(int depth) {
        for (int i = 0; i < depth; ++i) {
            this.workItemLevels.add("w" + i);
        }
        return this;
    }

    public WorkItemSelectQueryBuilder withPlanId(String planId) {
        this.planId = planId;
        return this;
    }

    public WorkItemSelectQueryBuilder withReplanning(boolean include) {
        this.includeReplanning = include;
        return this;
    }

    public WorkItemSelectQueryBuilder withDone(boolean include) {
        this.includeDone = include;
        return this;
    }

    public WorkItemSelectQueryBuilder withDoneDependencies(boolean include) {
        this.includeDoneDependencies = include;
        return this;
    }

    public WorkItemSelectQueryBuilder enrichWithExtensions(ProgressConfiguration progressConfiguration) {
        this.enrichWithExtensions = true;
        this.progressConfiguration = progressConfiguration;
        return this;
    }

    public WorkItemSelectQueryBuilder withSpecificIdRange(List<String> ids) {
        this.idRange = ids;
        return this;
    }

    public WorkItemSelectQueryBuilder withFilter(IWorkItemFilter filter, WorkItemSolutionFilterResult solutionFilterResult) {
        this.filter = filter;
        this.solutionFilterResult = solutionFilterResult;
        return this;
    }

    public MonitoredCallResult<? extends List<? extends IWorkItem>> execute() throws SQLException {
        if (this.workItemLevels.size() == 0) {
            this.withWorkItemRelationDepth(3);
        }
        final boolean skipCompleted = !this.includeDone && (this.filter == null || this.filter.getShowCompleted() == null || this.filter.getShowCompleted() == false);
        final boolean filteringEnabled = this.filter != null && this.solutionFilterResult != null;
        return this.sql(new IQuery<MonitoredCallResult<? extends List<? extends IWorkItem>>>(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                for (String workItemHierarchy : WorkItemSelectQueryBuilder.this.workItemLevels) {
                    generator.withTable(AOWorkItem.class, workItemHierarchy);
                }
                for (String replanningRelation : replanningRelations.keySet()) {
                    generator.withTable(AOReplanning.class, replanningRelation);
                }
                generator.withTable(AOEstimate.class, WorkItemSelectQueryBuilder.TABLE_ESTIMATE);
                generator.select();
                for (String workItemHierarchy : WorkItemSelectQueryBuilder.this.workItemLevels) {
                    WorkItemTableHelper.addColumnsToSelect(workItemHierarchy, WorkItemSelectQueryBuilder.this.includeReplanning, generator);
                }
                EstimateTableHelper.addColumnsToSelect(WorkItemSelectQueryBuilder.TABLE_ESTIMATE, generator);
                if (WorkItemSelectQueryBuilder.this.includeReplanning) {
                    for (String replanningRelation : replanningRelations.keySet()) {
                        ReplanningTableHelper.addReplanningSelects(replanningRelation, generator);
                    }
                }
                generator.raw("FROM (").withTable(AOWorkItem.class, "fromW").select().raw("*").from("fromW").where().col("fromW", "aoPlan").eq().numeric(WorkItemSelectQueryBuilder.this.planId).raw(")").raw(WorkItemSelectQueryBuilder.this.workItemLevels.get(0));
                for (int i = 1; i < WorkItemSelectQueryBuilder.this.workItemLevels.size(); ++i) {
                    WorkItemTableHelper.addJoin((String)WorkItemSelectQueryBuilder.this.workItemLevels.get(i), (String)WorkItemSelectQueryBuilder.this.workItemLevels.get(i - 1), WorkItemSelectQueryBuilder.this.planId, generator);
                }
                EstimateTableHelper.addEstimateJoin(WorkItemSelectQueryBuilder.TABLE_ESTIMATE, WorkItemSelectQueryBuilder.this.workItemLevels, WorkItemSelectQueryBuilder.this.includeReplanning, filteringEnabled, WorkItemSelectQueryBuilder.this.filter, generator);
                if (WorkItemSelectQueryBuilder.this.includeReplanning) {
                    for (Map.Entry<String, String> replanningRelationEntry : replanningRelations.entrySet()) {
                        ReplanningTableHelper.addReplanningJoin(replanningRelationEntry.getKey(), replanningRelationEntry.getValue(), WorkItemSelectQueryBuilder.this.workItemLevels, generator);
                    }
                }
                generator.where();
                if (WorkItemSelectQueryBuilder.this.idRange != null) {
                    generator.raw("(");
                    generator.inNumeric(new AOQueryGenerator.InOperandCallback(){

                        @Override
                        public void generateOperand(AOQueryGenerator generator) {
                            generator.colId((String)WorkItemSelectQueryBuilder.this.workItemLevels.get(0));
                        }
                    }, WorkItemSelectQueryBuilder.this.idRange);
                    for (int i = 1; i < WorkItemSelectQueryBuilder.this.workItemLevels.size(); ++i) {
                        final String workItemLevel = (String)WorkItemSelectQueryBuilder.this.workItemLevels.get(i);
                        generator.or().inNumeric(new AOQueryGenerator.InOperandCallback(){

                            @Override
                            public void generateOperand(AOQueryGenerator generator) {
                                generator.colId(workItemLevel);
                            }
                        }, WorkItemSelectQueryBuilder.this.idRange);
                    }
                    generator.raw(")");
                    generator.and();
                }
                generator.col((String)WorkItemSelectQueryBuilder.this.workItemLevels.get(0), "aoParent").isNull();
                generator.and().col((String)WorkItemSelectQueryBuilder.this.workItemLevels.get(0), "aoPlan").eq().numeric(WorkItemSelectQueryBuilder.this.planId);
                if (skipCompleted) {
                    for (final String workItemLevel : WorkItemSelectQueryBuilder.this.workItemLevels) {
                        generator.and().raw("(").col(workItemLevel, "status").isNull().or().col(workItemLevel, "status").neq().numeric(WorkItemStatus.COMPLETED.value()).raw(")");
                    }
                }
                if (filteringEnabled) {
                    FilterHelper.addTitleFilter(WorkItemSelectQueryBuilder.this.workItemLevels, WorkItemSelectQueryBuilder.this.filter, generator);
                    FilterHelper.addRelationFilter("aoRelease", WorkItemSelectQueryBuilder.this.workItemLevels, WorkItemSelectQueryBuilder.this.filter.getReleaseIds(), WorkItemSelectQueryBuilder.this.solutionFilterResult.getReleaseWorkItemIds(), generator);
                    FilterHelper.addRelationFilter("aoTeam", WorkItemSelectQueryBuilder.this.workItemLevels, WorkItemSelectQueryBuilder.this.filter.getTeamIds(), WorkItemSelectQueryBuilder.this.solutionFilterResult.getTeamWorkItemIds(), generator);
                    FilterHelper.addRelationFilter("aoTheme", WorkItemSelectQueryBuilder.this.workItemLevels, WorkItemSelectQueryBuilder.this.filter.getThemeIds(), null, generator);
                    FilterHelper.addDateRangeFilter(WorkItemSelectQueryBuilder.this.workItemLevels, WorkItemSelectQueryBuilder.this.solutionFilterResult.getDateRangeWorkItemIds(), generator);
                }
                generator.orderBy();
                OrderByHelper.addOrderByClause(generator, WorkItemSelectQueryBuilder.this.workItemLevels);
            }

            @Override
            public MonitoredCallResult<? extends List<? extends IWorkItem>> handleResult(ResultSet result) throws Exception {
                return WorkItemSelectQueryBuilder.this.parser.parse(WorkItemSelectQueryBuilder.this.planId, result, WorkItemSelectQueryBuilder.this.filter, WorkItemSelectQueryBuilder.this.includeReplanning, WorkItemSelectQueryBuilder.this.includeDoneDependencies, WorkItemSelectQueryBuilder.this.enrichWithExtensions, WorkItemSelectQueryBuilder.this.progressConfiguration);
            }
        });
    }

    static {
        replanningRelations.put("replanningTeam", "team");
        replanningRelations.put("replanningRelese", "release");
        replanningRelations.put("replanningStream", "stream");
    }
}

