/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.port;

import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.persistence.ao.port.AOEntityTransformationUtil;
import com.radiantminds.roadmap.common.data.persistence.ao.port.DbEntityTranslator;
import com.radiantminds.roadmap.common.data.persistence.ao.port.IdMapper;
import com.radiantminds.roadmap.common.data.persistence.ao.port.MethodXmlConfiguration;
import com.radiantminds.roadmap.common.data.persistence.ao.port.PortProgress;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.AOQueryGenerator;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.BaseAOPersistenceSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.statements.IQuery;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.XmlExportablePersistence;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AOTableExporter
extends BaseAOPersistenceSQL {
    private final AOEntityTransformationUtil transformationUtil;

    public AOTableExporter(ActiveObjectsUtilities activeObjectsUtilities) {
        super(activeObjectsUtilities);
        this.transformationUtil = new AOEntityTransformationUtil(activeObjectsUtilities);
    }

    public static IQuery<Integer> getRowCount(final XmlExportablePersistence persistence, final String planId) throws SQLException {
        return new IQuery<Integer>(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                persistence.getRowCountQueryForPlan(generator, planId);
            }

            @Override
            public Integer handleResult(ResultSet result) throws Exception {
                if (result.next()) {
                    return BaseAOPersistenceSQL.getInt(result, 1);
                }
                return 0;
            }
        };
    }

    public IQuery<Element> getQuery(final String planId, final XmlExportablePersistence persistence, final Document doc, final IdMapper idMapper, final PortProgress progress, final boolean anonymise) {
        return new IQuery<Element>(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                persistence.selectAllForPlan(generator, planId, true);
            }

            @Override
            public Element handleResult(ResultSet result) throws Exception {
                Map<String, MethodXmlConfiguration> methodMap = AOTableExporter.this.transformationUtil.getColumnNameToXmlConfiguration(persistence);
                String tableElementName = AOTableExporter.this.transformationUtil.getXmlNameForTable(persistence.getDbInterfaceClass());
                String rowElementName = AOTableExporter.this.transformationUtil.getXmlNameForRow(persistence.getDbInterfaceClass());
                DbEntityTranslator translator = new DbEntityTranslator(result.getMetaData(), methodMap);
                Element tableElement = doc.createElement(tableElementName);
                while (result.next()) {
                    Element itemElement = doc.createElement(rowElementName);
                    translator.translateRowIntoElement(result, doc, itemElement, idMapper, anonymise);
                    tableElement.appendChild(itemElement);
                    progress.next();
                }
                return tableElement;
            }
        };
    }
}

