/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.port;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.persistence.ao.port.AOEntityTransformationUtil;
import com.radiantminds.roadmap.common.data.persistence.ao.port.AOTableImportData;
import com.radiantminds.roadmap.common.data.persistence.ao.port.IdMapper;
import com.radiantminds.roadmap.common.data.persistence.ao.port.MethodXmlConfiguration;
import com.radiantminds.roadmap.common.data.persistence.ao.port.PortProgress;
import com.radiantminds.roadmap.common.data.persistence.ao.port.TranslationException;
import com.radiantminds.roadmap.common.data.persistence.ao.port.XmlExportablePersistenceIndex;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.AOQueryGenerator;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.BaseAOPersistenceSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.statements.IInsert;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AOTableImporter
extends BaseAOPersistenceSQL {
    private final AOEntityTransformationUtil transformationUtil;

    public AOTableImporter(ActiveObjectsUtilities activeObjectsUtilities) {
        super(activeObjectsUtilities);
        this.transformationUtil = new AOEntityTransformationUtil(activeObjectsUtilities);
    }

    public List<IInsert> getInsertsForTable(final AOTableImportData data, final IdMapper idMapper, final PortProgress progress, XmlExportablePersistenceIndex index) throws TranslationException, SQLException {
        ArrayList retVal = Lists.newArrayList();
        final Map<String, MethodXmlConfiguration> methodMap = this.transformationUtil.getTagNameToXmlConfiguration(data.getAoTableClazz(), index);
        for (final Map<String, String> row : data.getRows()) {
            IInsert insert = new IInsert(){

                @Override
                public void sql(AOQueryGenerator generator) throws Exception {
                    generator.withTable(data.getAoTableClazz(), "t").insert().tableNoAlias("t").raw("(");
                    for (String key : row.keySet()) {
                        if (((MethodXmlConfiguration)methodMap.get(key)).isPrimaryKey()) continue;
                        if (((MethodXmlConfiguration)methodMap.get(key)).isPolyType()) {
                            generator.colPolyTypeNoAlias("t", ((MethodXmlConfiguration)methodMap.get(key)).getMethodName());
                            continue;
                        }
                        generator.colNoAlias("t", ((MethodXmlConfiguration)methodMap.get(key)).getMethodName());
                    }
                    generator.raw(") VALUES (");
                    boolean first = true;
                    for (String key : row.keySet()) {
                        if (((MethodXmlConfiguration)methodMap.get(key)).isPrimaryKey()) continue;
                        if (!first) {
                            generator.raw(",");
                        } else {
                            first = false;
                        }
                        AOTableImporter.addDataToInsert(generator, (MethodXmlConfiguration)methodMap.get(key), (String)row.get(key), row, idMapper);
                    }
                    generator.raw(")");
                }

                @Override
                public void handleResult(String newId) throws Exception {
                    String pk = null;
                    for (String key : row.keySet()) {
                        if (!((MethodXmlConfiguration)methodMap.get(key)).isPrimaryKey()) continue;
                        pk = (String)row.get(key);
                    }
                    idMapper.put(data.getAoTableClazz(), pk, newId);
                    progress.next();
                }
            };
            retVal.add(insert);
        }
        return retVal;
    }

    private static void addDataToInsert(AOQueryGenerator generator, MethodXmlConfiguration config, String value, Map<String, String> row, IdMapper idMapper) throws TranslationException {
        if (config.isForeignKey()) {
            String dependence = row.get(config.getDependsOn());
            Class<?> relation = config.getResolver().resolve(dependence);
            if (relation != null) {
                String prefix = config.getResolver().getPrefix(dependence);
                if (prefix != null) {
                    value = value.substring(prefix.length());
                }
                String newValue = idMapper.getWithoutMapping(relation, value);
                if (prefix != null) {
                    newValue = prefix + newValue;
                }
                value = newValue;
            }
        }
        if (config.getReturnType() == String.class || config.getReturnType().isEnum()) {
            generator.str(value);
        } else if (config.getReturnType() == Boolean.class || config.getReturnType() == Boolean.TYPE) {
            generator.bool(Boolean.parseBoolean(value));
        } else if (config.getReturnType() == Integer.class || config.getReturnType() == Integer.TYPE) {
            generator.numeric(value);
        } else if (config.getReturnType() == Double.class || config.getReturnType() == Double.TYPE) {
            generator.numeric(Double.parseDouble(value));
        } else if (config.getReturnType() == Long.class || config.getReturnType() == Long.TYPE) {
            generator.numeric(Long.parseLong(value));
        } else {
            throw new TranslationException("Unknown method return type '" + config.getReturnType() + "'");
        }
    }

    public AOTableImportData parseElement(Element tableElement) throws TranslationException {
        Class<?> tableClazz = this.transformationUtil.getTableForXmlName(tableElement.getTagName());
        if (tableClazz == null) {
            throw new TranslationException("Unknown table '" + tableElement + "' in XML.");
        }
        String rowName = this.transformationUtil.getXmlNameForRow(tableClazz);
        AOTableImportData importData = new AOTableImportData(tableClazz, rowName);
        NodeList rowList = tableElement.getElementsByTagName(rowName);
        for (int i = 0; i < rowList.getLength(); ++i) {
            Element rowElement = (Element)rowList.item(i);
            HashMap row = Maps.newHashMap();
            NamedNodeMap attributes = rowElement.getAttributes();
            for (int j = 0; j < attributes.getLength(); ++j) {
                Node attribute = attributes.item(j);
                row.put(attribute.getNodeName(), attribute.getNodeValue());
            }
            NodeList rowTags = rowElement.getElementsByTagName("*");
            for (int j = 0; j < rowTags.getLength(); ++j) {
                Node child = rowTags.item(j);
                if (!(child instanceof Element)) continue;
                Element rowTag = (Element)rowTags.item(j);
                String columnName = rowTag.getTagName();
                String content = rowTag.getTextContent();
                if (rowTag.hasAttribute("encoding")) {
                    String encoding = rowTag.getAttribute("encoding");
                    if ("base64".equals(encoding)) {
                        content = new String(Base64.decodeBase64(content));
                    } else {
                        throw new TranslationException("Unknown encoding '" + encoding + "'.");
                    }
                }
                row.put(columnName, content);
            }
            importData.addRow(row);
        }
        return importData;
    }
}

