/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.port;

import com.atlassian.pocketknife.api.logging.Log;
import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.common.io.Resources;
import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.entities.plans.FullContentSchedulingPlan;
import com.radiantminds.roadmap.common.data.entities.plans.IPlan;
import com.radiantminds.roadmap.common.data.entities.plans.PlanningUnit;
import com.radiantminds.roadmap.common.data.entities.plans.TrackerType;
import com.radiantminds.roadmap.common.data.generator.template.PlanTemplate;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.permissions.AOPermission;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.plans.AOPlan;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.plans.AOPlanConfiguration;
import com.radiantminds.roadmap.common.data.persistence.ao.port.AOTableImportData;
import com.radiantminds.roadmap.common.data.persistence.ao.port.AOTableImporter;
import com.radiantminds.roadmap.common.data.persistence.ao.port.IdMapper;
import com.radiantminds.roadmap.common.data.persistence.ao.port.PortProgress;
import com.radiantminds.roadmap.common.data.persistence.ao.port.TableForeignKeySorter;
import com.radiantminds.roadmap.common.data.persistence.ao.port.TranslationException;
import com.radiantminds.roadmap.common.data.persistence.ao.port.XmlExportablePersistenceIndex;
import com.radiantminds.roadmap.common.data.persistence.ao.port.XmlUtils;
import com.radiantminds.roadmap.common.data.persistence.ao.port.dynamics.DynamicValueHandlers;
import com.radiantminds.roadmap.common.data.persistence.ao.port.legacy.DocumentLegacyChecker;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.transactions.BaseTransactionalAOPersistenceSQL;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioPermissionPersistence;
import com.radiantminds.roadmap.common.rest.entities.permissions.RestPermission;
import com.radiantminds.roadmap.common.scheduling.entities.SchedulingPlanFactory;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.xml.parsers.DocumentBuilder;
import org.apache.commons.io.IOUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PlanImporter
extends BaseTransactionalAOPersistenceSQL {
    private static final Log LOGGER = Log.with(PlanImporter.class);
    private final XmlExportablePersistenceIndex index;
    private final ActiveObjectsUtilities activeObjectsUtilities;
    private final SchedulingPlanFactory schedulingPlanFactory;
    private final DocumentLegacyChecker documentLegacyChecker;
    private final PortfolioPermissionPersistence permissionPersistence;
    private final DynamicValueHandlers dynamicValueHandlers;

    public PlanImporter(XmlExportablePersistenceIndex index, ActiveObjectsUtilities activeObjectsUtilities, SchedulingPlanFactory schedulingPlanFactory, DocumentLegacyChecker documentLegacyChecker, PortfolioPermissionPersistence permissionPersistence, DynamicValueHandlers dynamicValueHandlers) {
        super(activeObjectsUtilities);
        this.index = index;
        this.activeObjectsUtilities = activeObjectsUtilities;
        this.schedulingPlanFactory = schedulingPlanFactory;
        this.documentLegacyChecker = documentLegacyChecker;
        this.permissionPersistence = permissionPersistence;
        this.dynamicValueHandlers = dynamicValueHandlers;
    }

    public IPlan createPlanFromResource(@Nullable String title, @Nullable String description, @Nullable String planningUnit, String accessMode, @Nullable String userId, PlanTemplate template) throws Exception {
        String resourcePath = String.format("/plans/%s.xml", template.toString());
        URL resource = PlanImporter.class.getResource(resourcePath);
        String xml = Resources.toString((URL)resource, (Charset)Charsets.UTF_8);
        String planId = this.importPlan(xml, accessMode, title, description, planningUnit, userId, new PortProgress());
        return this.schedulingPlanFactory.create(planId);
    }

    public FullContentSchedulingPlan importPlanFromFile(String filePath) throws Exception {
        URL resource = Resources.getResource((String)filePath);
        String xml = Resources.toString((URL)resource, (Charset)Charsets.UTF_8);
        String planId = this.importPlan(xml, null, null, null, null, null, new PortProgress());
        return this.schedulingPlanFactory.create(planId);
    }

    public String importPlan(String xml, String accessMode, @Nullable String title, @Nullable String description, @Nullable String planningUnit, @Nullable String userId, PortProgress progress) throws Exception {
        DocumentBuilder docBuilder = XmlUtils.getDocumentBuilder();
        Document document = docBuilder.parse(IOUtils.toInputStream(xml, "UTF-8"));
        Element documentElement = document.getDocumentElement();
        if (!"roadmap".equals(documentElement.getTagName())) {
            throw TranslationException.noValidPlan();
        }
        if (!documentElement.hasAttribute("version")) {
            throw TranslationException.noValidPlan();
        }
        String version = documentElement.getAttribute("version");
        List<Element> tableElements = PlanImporter.getTableElements(documentElement);
        ArrayList importData = Lists.newArrayList();
        AOTableImportData planImportData = null;
        AOTableImportData permissionImportData = null;
        AOTableImportData planConfigurationImportData = null;
        AOTableImporter aoTableImporter = new AOTableImporter(this.activeObjectsUtilities);
        int rowCount = 0;
        for (Element tableElement : tableElements) {
            AOTableImportData data = aoTableImporter.parseElement(tableElement);
            if (data.getAoTableClazz() == AOPlan.class) {
                planImportData = data;
            }
            if (data.getAoTableClazz() == AOPermission.class) {
                permissionImportData = data;
            }
            if (data.getAoTableClazz() == AOPlanConfiguration.class) {
                planConfigurationImportData = data;
            }
            this.dynamicValueHandlers.applyTo(data);
            importData.add(data);
            rowCount += data.getRows().size();
        }
        Map<String, String> planRow = planImportData.getRows().get(0);
        if (title != null) {
            planRow.put("title", title);
        }
        if (description != null) {
            planRow.put("details", description);
        }
        Map<String, String> planConfigurationRow = planConfigurationImportData.getRows().get(0);
        if (planningUnit != null) {
            planConfigurationRow.put("planningunit", planningUnit);
            if (PlanningUnit.STORY_POINTS.toString().equals(planningUnit)) {
                planConfigurationRow.put("aoprogresstrackertype", TrackerType.StoryPoints.toString());
                planConfigurationRow.put("suggestreplestimates", Boolean.FALSE.toString());
            }
        }
        importData.remove(permissionImportData);
        progress.setTotal(rowCount);
        this.documentLegacyChecker.adaptDocument(version, importData);
        IdMapper idMapper = new IdMapper(this.index);
        ArrayList inserts = Lists.newArrayList();
        for (AOTableImportData data : TableForeignKeySorter.getSortedTables(importData)) {
            inserts.addAll(aoTableImporter.getInsertsForTable(data, idMapper, progress, this.index));
        }
        this.handleInsertsInTransaction(inserts);
        String planId = idMapper.getPlanId();
        if (accessMode != null && !"all".equals(accessMode) && userId != null) {
            RestPermission editPermission = RestPermission.createPlanEditorUserPermission(planId, userId);
            this.permissionPersistence.persistCached(editPermission);
            RestPermission viewPermission = RestPermission.createPlanViewerUserPermission(planId, userId);
            this.permissionPersistence.persistCached(viewPermission);
        }
        LOGGER.info("imported plan with ID: %s", planId);
        return planId;
    }

    private static final List<Element> getTableElements(Element documentElement) {
        ArrayList retVal = Lists.newArrayList();
        NodeList tableNodes = documentElement.getChildNodes();
        for (int i = 0; i < tableNodes.getLength(); ++i) {
            Element tableElement;
            Node child = tableNodes.item(i);
            if (!(child instanceof Element) || !(tableElement = (Element)tableNodes.item(i)).getTagName().endsWith("Collection")) continue;
            retVal.add(tableElement);
        }
        return retVal;
    }
}

