/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.port;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.radiantminds.roadmap.common.data.persistence.ao.port.AOTableImportData;
import com.radiantminds.roadmap.common.data.persistence.ao.port.TranslationException;
import com.radiantminds.roadmap.common.data.persistence.ao.port.XmlTableForeignKeys;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.XmlExportablePersistence;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TableForeignKeySorter {
    public static List<XmlExportablePersistence> getSortedPersistences(Collection<XmlExportablePersistence> data) throws TranslationException {
        HashMap clazzMap = Maps.newHashMap();
        for (XmlExportablePersistence item : data) {
            clazzMap.put(item.getDbInterfaceClass(), item);
        }
        return TableForeignKeySorter.getSortedTables(clazzMap);
    }

    public static List<AOTableImportData> getSortedTables(List<AOTableImportData> data) throws TranslationException {
        HashMap clazzMap = Maps.newHashMap();
        for (AOTableImportData item : data) {
            clazzMap.put(item.getAoTableClazz(), item);
        }
        return TableForeignKeySorter.getSortedTables(clazzMap);
    }

    private static <T> List<T> getSortedTables(Map<Class<?>, T> unsorted) throws TranslationException {
        HashMap openKeys = Maps.newHashMap();
        for (Class<?> tableClazz : unsorted.keySet()) {
            openKeys.put(tableClazz, TableForeignKeySorter.getForeignKeyDependencies(tableClazz));
        }
        ArrayList retVal = Lists.newArrayList();
        while (openKeys.size() > 0) {
            Class<?> next = TableForeignKeySorter.getNextFreeClazz(openKeys);
            retVal.add(unsorted.get(next));
            openKeys.remove(next);
            for (Map.Entry entry : openKeys.entrySet()) {
                ((Set)entry.getValue()).remove(next);
            }
        }
        return retVal;
    }

    private static Class<?> getNextFreeClazz(Map<Class<?>, Set<Class<?>>> map) throws TranslationException {
        ArrayList candidateNames = Lists.newArrayList();
        HashMap candidates = Maps.newHashMap();
        for (Map.Entry<Class<?>, Set<Class<?>>> entry : map.entrySet()) {
            if (entry.getValue().size() != 0) continue;
            String candidateName = entry.getKey().getSimpleName();
            candidateNames.add(candidateName);
            candidates.put(candidateName, entry.getKey());
        }
        if (candidates.size() > 0) {
            Collections.sort(candidateNames);
            return (Class)candidates.get(candidateNames.get(0));
        }
        throw new TranslationException("Unable to determine class sort order based on foreign keys.");
    }

    private static Set<Class<?>> getForeignKeyDependencies(Class<?> aoClazz) {
        HashSet retVal = Sets.newHashSet();
        if (aoClazz.isAnnotationPresent(XmlTableForeignKeys.class)) {
            for (Class<?> dependency : aoClazz.getAnnotation(XmlTableForeignKeys.class).value()) {
                retVal.add(dependency);
                retVal.addAll(TableForeignKeySorter.getForeignKeyDependencies(dependency));
            }
        }
        return retVal;
    }
}

