/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.port.legacy.modifiers;

import com.atlassian.pocketknife.api.logging.Log;
import com.google.common.base.Optional;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.releases.AORelease;
import com.radiantminds.roadmap.common.data.persistence.ao.port.AOTableImportData;
import com.radiantminds.roadmap.common.data.persistence.ao.port.legacy.BaseLegacyDocumentModifier;
import com.radiantminds.roadmap.common.utils.JPOVersion;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component
public class LaterReleaseVersionModifier
extends BaseLegacyDocumentModifier {
    private static final Log LOGGER = Log.with(LaterReleaseVersionModifier.class);

    @Override
    public JPOVersion isRelevantBeforeVersion() {
        return new JPOVersion(1, 8, 0);
    }

    @Override
    public void modify(List<AOTableImportData> importData) {
        Optional<AOTableImportData> releaseData = this.getDataFor(AORelease.class, importData);
        if (!releaseData.isPresent()) {
            return;
        }
        if (releaseData != null && ((AOTableImportData)releaseData.get()).getRows() != null) {
            for (Map<String, String> release : ((AOTableImportData)releaseData.get()).getRows()) {
                if (release.containsKey("version")) continue;
                LOGGER.info("Legacy import: Setting release entity version for '" + release.get("title") + "'", new Object[0]);
                release.put("version", "0");
            }
        }
    }
}

