/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.sql;

import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.AOInChunkedQueryGenerator;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.AOQueryGenerator;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.regex.Pattern;

public class OracleAOQueryGenerator
extends AOInChunkedQueryGenerator {
    private static final Pattern WORD_PATTERN = Pattern.compile("([a-z\\d])([A-Z])");

    protected OracleAOQueryGenerator(Connection connection, ActiveObjectsUtilities activeObjectsUtilities) throws SQLException {
        super(connection, activeObjectsUtilities);
    }

    @Override
    public AOQueryGenerator bool(Boolean b) {
        if (b != null && b.booleanValue()) {
            return this.raw(1);
        }
        return this.raw(0);
    }

    @Override
    protected void appendNonMethodField(String fk) {
        String oraField = WORD_PATTERN.matcher(fk).replaceAll("$1_$2").toUpperCase();
        super.appendNonMethodField(oraField);
    }

    @Override
    public AOQueryGenerator lowerCase() {
        return this.raw("LOWER");
    }

    @Override
    protected AOQueryGenerator varchar() {
        return this.raw("VARCHAR2(30)", false);
    }
}

