/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.sql.transactions;

import com.google.common.collect.Lists;
import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.statements.IStatement;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.transactions.BaseTransactionalAOPersistenceSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.transactions.IResultAwareQuery;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.transactions.ITransactionalFuture;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;

public class SQLTransaction
extends BaseTransactionalAOPersistenceSQL {
    private final List<IStatement> statements = Lists.newArrayList();
    private ITransactionalFuture<?> lastFuture;

    private SQLTransaction(ActiveObjectsUtilities activeObjectsUtilities) {
        super(activeObjectsUtilities);
    }

    public static SQLTransaction create(ActiveObjectsUtilities activeObjectsUtilities) {
        return new SQLTransaction(activeObjectsUtilities);
    }

    public List<IStatement> getStatements() {
        return this.statements;
    }

    public void add(IStatement statement) {
        this.statements.add(statement);
    }

    public <TResult> ITransactionalFuture<TResult> add(SQLTransaction transaction) {
        this.statements.addAll(transaction.getStatements());
        return transaction.getLastFuture();
    }

    public <TResult> ITransactionalFuture<TResult> add(IResultAwareQuery<TResult> query) {
        this.statements.add(query.query());
        this.lastFuture = query;
        return query;
    }

    public <TResult> ITransactionalFuture<TResult> addNonExecutedFuture(ITransactionalFuture<TResult> future) {
        this.lastFuture = future;
        return future;
    }

    public void execute() throws SQLException {
        this.handleInTransactionWithoutResults(this.statements);
    }

    public void execute(Connection connection) throws SQLException {
        this.executeStatementsInTransaction(this.statements, connection);
    }

    public <TResult> ITransactionalFuture<TResult> getLastFuture() {
        return this.lastFuture;
    }
}

