/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.upgrade.tasks;

import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.persistence.PersistenceIndex;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.people.AOAbility;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.skills.AOSkill;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.skills.AOStage;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.AOQueryGenerator;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.BaseAOPersistenceSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.statements.IUpdate;
import com.radiantminds.roadmap.common.data.persistence.ao.upgrade.BaseUpgradeTask;
import java.sql.SQLException;

public class U_01100_AbilityZombieUpgradeTask
extends BaseUpgradeTask {
    @Override
    protected int getDataModelVersion() {
        return 1100;
    }

    @Override
    protected void performUpgrade(ActiveObjectsUtilities utils, PersistenceIndex persistenceIndex) throws Exception {
        UpgradeSQL sql = new UpgradeSQL(utils);
        sql.removeAbilityZombies(this, utils, AOSkill.class, "skill");
        sql.removeAbilityZombies(this, utils, AOStage.class, "stage");
    }

    @Override
    protected boolean migrateOnUpgrade() {
        return true;
    }

    private static class UpgradeSQL
    extends BaseAOPersistenceSQL {
        public UpgradeSQL(ActiveObjectsUtilities utils) {
            super(utils);
        }

        public void removeAbilityZombies(BaseUpgradeTask task, ActiveObjectsUtilities utils, final Class<?> targetClazz, final String targetType) throws SQLException {
            this.sql(new IUpdate(){

                @Override
                public void sql(AOQueryGenerator generator) throws Exception {
                    generator.withTable(AOAbility.class, "a").withTable(targetClazz, "b").deleteFrom().tableNoAlias("a").where().colNoAlias("a", "targetType").eq().str(targetType).and().colNoAlias("a", "targetId").raw("NOT IN (").select().colIdNoAlias("b").from(new String[0]).tableNoAlias("b").raw(")");
                }
            }, task.getOrCreateConnection(utils.getAccessor()));
        }
    }
}

