/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.extensions.analytics;

import com.radiantminds.roadmap.common.data.entities.plans.SchedulingPlan;
import com.radiantminds.roadmap.common.extensions.analytics.ConfigurationStatistics;
import com.radiantminds.roadmap.common.extensions.analytics.PersonStatistics;
import com.radiantminds.roadmap.common.extensions.analytics.StreamStatistics;
import com.radiantminds.roadmap.common.extensions.analytics.TeamStatistics;
import com.radiantminds.roadmap.common.extensions.analytics.WorkItemStatistics;

public class PlanProperties {
    private final Long numberOfUnstructuredEpics;
    private final Double averageUnstructuredEpicEstimate;
    private final Double unstructuredEpicEstimateStandardDeviation;
    private final Long numberOfStories;
    private final Double averageStoryEstimate;
    private final Double storyEstimateStandardDeviation;
    private final Long numberOfDependencies;
    private final Long numberOfScrumTeams;
    private final Long numberOfKanbanTeams;
    private final Long numberOfStrictTeamAssignment;
    private final Long numberOfResources;
    private final Long numberOfStrictResourceAssignments;
    private final Long numberOfStages;
    private final Long numberOfSkills;
    private final Double averageSkillsPerResource;
    private final Double skillsPerResourceStandardDeviation;
    private final Double skillsPerStageStandardDeviation;
    private final Long numberOfDynamicReleases;
    private final Long numberOfFixedEndDateReleases;
    private final Long numberOfStrictReleaseAssignments;
    private final String planningUnit;

    private PlanProperties(Long numberOfUnstructuredEpics, Double averageUnstructuredEpicEstimate, Double unstructuredEpicEstimateStandardDeviation, Long numberOfStories, Double averageStoryEstimate, Double storyEstimateStandardDeviation, Long numberOfDependencies, Long numberOfStrictReleaseAssignments, Long numberOfStrictTeamAssignment, Long numberOfStrictResourceAssignments, Long numberOfKanbanTeams, Long numberOfScrumTeams, Long numberOfResources, Double averageSkillsPerResource, Double skillsPerResourceStandardDeviation, Long numberOfStages, Long numberOfSkills, Double skillsPerStageStandardDeviation, Long numberOfDynamicReleases, Long numberOfFixedEndDateReleases, String planningUnit) {
        this.numberOfUnstructuredEpics = numberOfUnstructuredEpics;
        this.averageUnstructuredEpicEstimate = averageUnstructuredEpicEstimate;
        this.unstructuredEpicEstimateStandardDeviation = unstructuredEpicEstimateStandardDeviation;
        this.numberOfStories = numberOfStories;
        this.averageStoryEstimate = averageStoryEstimate;
        this.storyEstimateStandardDeviation = storyEstimateStandardDeviation;
        this.numberOfDependencies = numberOfDependencies;
        this.numberOfScrumTeams = numberOfScrumTeams;
        this.numberOfKanbanTeams = numberOfKanbanTeams;
        this.numberOfStrictTeamAssignment = numberOfStrictTeamAssignment;
        this.numberOfResources = numberOfResources;
        this.numberOfStrictResourceAssignments = numberOfStrictResourceAssignments;
        this.numberOfStages = numberOfStages;
        this.numberOfSkills = numberOfSkills;
        this.averageSkillsPerResource = averageSkillsPerResource;
        this.skillsPerResourceStandardDeviation = skillsPerResourceStandardDeviation;
        this.skillsPerStageStandardDeviation = skillsPerStageStandardDeviation;
        this.numberOfDynamicReleases = numberOfDynamicReleases;
        this.numberOfFixedEndDateReleases = numberOfFixedEndDateReleases;
        this.numberOfStrictReleaseAssignments = numberOfStrictReleaseAssignments;
        this.planningUnit = planningUnit;
    }

    public String getPlanningUnit() {
        return this.planningUnit;
    }

    public Long getNumberOfUnstructuredEpics() {
        return this.numberOfUnstructuredEpics;
    }

    public Double getAverageUnstructuredEpicEstimate() {
        return this.averageUnstructuredEpicEstimate;
    }

    public Double getUnstructuredEpicEstimateStandardDeviation() {
        return this.unstructuredEpicEstimateStandardDeviation;
    }

    public Long getNumberOfStories() {
        return this.numberOfStories;
    }

    public Double getAverageStoryEstimate() {
        return this.averageStoryEstimate;
    }

    public Double getStoryEstimateStandardDeviation() {
        return this.storyEstimateStandardDeviation;
    }

    public Long getNumberOfDependencies() {
        return this.numberOfDependencies;
    }

    public Long getNumberOfScrumTeams() {
        return this.numberOfScrumTeams;
    }

    public Long getNumberOfKanbanTeams() {
        return this.numberOfKanbanTeams;
    }

    public Long getNumberOfStrictTeamAssignments() {
        return this.numberOfStrictTeamAssignment;
    }

    public Long getNumberOfResources() {
        return this.numberOfResources;
    }

    public Long getNumberOfStrictResourceAssignments() {
        return this.numberOfStrictResourceAssignments;
    }

    public Long getNumberOfStages() {
        return this.numberOfStages;
    }

    public Long getNumberOfSkills() {
        return this.numberOfSkills;
    }

    public Double getAverageSkillsPerResource() {
        return this.averageSkillsPerResource;
    }

    public Double getSkillsPerResourceStandardDeviation() {
        return this.skillsPerResourceStandardDeviation;
    }

    public Double getSkillsPerStageStandardDeviation() {
        return this.skillsPerStageStandardDeviation;
    }

    public Long getNumberOfDynamicReleases() {
        return this.numberOfDynamicReleases;
    }

    public Long getNumberOfFixedEndDateReleases() {
        return this.numberOfFixedEndDateReleases;
    }

    public Long getNumberOfStrictReleaseAssignments() {
        return this.numberOfStrictReleaseAssignments;
    }

    public static PlanProperties createFromPlan(SchedulingPlan plan) {
        WorkItemStatistics workItemStatistics = WorkItemStatistics.create(plan);
        TeamStatistics teamStatistics = TeamStatistics.create(plan.getTeams());
        PersonStatistics personStatistics = PersonStatistics.create(plan.getPersons());
        ConfigurationStatistics configurationStatistics = ConfigurationStatistics.create(plan.getStages());
        StreamStatistics streamStatistics = StreamStatistics.create(plan.getStreams());
        return new PlanProperties(workItemStatistics.getCntUnstructuredEpics(), workItemStatistics.getAvgUnstructuredEpicsEstimate(), workItemStatistics.getStdDevUnstructuredEpicsEstimate(), workItemStatistics.getCntStories(), workItemStatistics.getAvgStoriesEstimate(), workItemStatistics.getStdDevStoriesEstimate(), workItemStatistics.numberOfDependencies(), workItemStatistics.numberOfStrictReleaseAssignments(), workItemStatistics.numberOfStrictTeamAssignment(), workItemStatistics.numberOfStrictResourceAssignments(), teamStatistics.getKanbanCount(), teamStatistics.getScrumCount(), personStatistics.getPersonCount(), personStatistics.getAvgAbilities(), personStatistics.getStdDevAbilities(), configurationStatistics.getStageCount(), configurationStatistics.getSkillCount(), configurationStatistics.getStdSkillPerStage(), streamStatistics.getDynamicReleaseCount(), streamStatistics.getFixedEndReleaseCount(), plan.getPlanConfiguration().getPlanningUnit());
    }
}

