/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.extensions.issues;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Set;

public class IssueSyncData {
    private final String id;
    private Optional<String> title;
    private Optional<String> description;
    private boolean syncEstimate;
    private static Function<IssueSyncData, String> TO_ID = new Function<IssueSyncData, String>(){

        public String apply(IssueSyncData issueSyncData) {
            return issueSyncData.getId();
        }
    };
    private static Predicate<IssueSyncData> IS_PERSISTED = new Predicate<IssueSyncData>(){

        public boolean apply(IssueSyncData issueSyncData) {
            return issueSyncData.getId() != null;
        }
    };

    public IssueSyncData(String id) {
        this.id = id;
        this.title = Optional.absent();
        this.description = Optional.absent();
        this.syncEstimate = false;
    }

    public String getId() {
        return this.id;
    }

    public boolean isSyncEstimate() {
        return this.syncEstimate;
    }

    public void setSyncEstimate(boolean syncEstimate) {
        this.syncEstimate = syncEstimate;
    }

    public Optional<String> getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = Optional.fromNullable((Object)title);
    }

    public Optional<String> getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = Optional.fromNullable((Object)description);
    }

    public static IssueSyncData createEstimateSyncFor(String workItemID) {
        IssueSyncData data = new IssueSyncData(workItemID);
        data.setSyncEstimate(true);
        return data;
    }

    public static List<IssueSyncData> createEstimateSyncFor(Set<String> workItemIDs) {
        return Lists.newArrayList((Iterable)Iterables.transform(workItemIDs, (Function)new Function<String, IssueSyncData>(){

            public IssueSyncData apply(String s) {
                return IssueSyncData.createEstimateSyncFor(s);
            }
        }));
    }

    public static Function<IssueSyncData, String> toId() {
        return TO_ID;
    }

    public static Predicate<IssueSyncData> isPersisted() {
        return IS_PERSISTED;
    }
}

