/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.handlers;

import com.atlassian.pocketknife.api.logging.Log;
import com.google.common.base.Optional;
import com.radiantminds.roadmap.common.data.entities.common.IIdentifiable;
import com.radiantminds.roadmap.common.handlers.BulkEntityContext;
import com.radiantminds.roadmap.common.handlers.BulkEntityContextParameter;
import com.radiantminds.roadmap.common.handlers.ContextAwareAnnotations;
import com.radiantminds.roadmap.common.handlers.EntityContext;
import com.radiantminds.roadmap.common.handlers.EntityParam;
import com.radiantminds.roadmap.common.handlers.ParameterType;
import com.sun.jersey.api.core.HttpContext;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.PathSegment;

class EntityParamExtractor {
    private static final Log LOGGER = Log.with(EntityParamExtractor.class);
    private final ContextAwareAnnotations contextConfig;

    EntityParamExtractor(ContextAwareAnnotations contextConfig) {
        this.contextConfig = contextConfig;
    }

    <U extends IIdentifiable> Optional<BulkEntityContext<U>> tryGetAndSetBulkEntityContext(HttpContext context) {
        if (this.contextConfig.requiresBulkEntityContext()) {
            return Optional.of(EntityParamExtractor.extractBulkEntityContext(context, this.contextConfig.getEntityParam()));
        }
        return Optional.absent();
    }

    <U extends IIdentifiable> Optional<EntityContext<U>> tryGetAndSetEntityContext(HttpContext context) {
        if (this.contextConfig.requiresEntityContext()) {
            Optional entityContext = Optional.of(EntityParamExtractor.extractEntityContext(context, this.contextConfig.getEntityParam()));
            context.getProperties().put("jpo-entity-context", entityContext.get());
            return entityContext;
        }
        return Optional.absent();
    }

    private static <U extends IIdentifiable> BulkEntityContext<U> extractBulkEntityContext(HttpContext httpContext, EntityParam entityParam) {
        try {
            BulkEntityContextParameter param = (BulkEntityContextParameter)httpContext.getRequest().getEntity(BulkEntityContextParameter.class);
            return BulkEntityContext.from(param.getEntityIds(), EntityParamExtractor.getExpectedPlanVersion(httpContext, entityParam));
        }
        catch (Exception ex) {
            LOGGER.errorDebug(ex, "Entity does not implement BulkEntityContextParameter. Bulk entity context cannot be created.", new Object[0]);
            return null;
        }
    }

    private static <U extends IIdentifiable> EntityContext<U> extractEntityContext(HttpContext httpContext, EntityParam entityParam) {
        String entityId = EntityParamExtractor.extract(httpContext, entityParam.idParameter(), entityParam.idParameterType());
        String clientId = EntityParamExtractor.extract(httpContext, entityParam.clientIdParameter(), entityParam.clientIdParameterType());
        return EntityContext.from(entityId, EntityParamExtractor.getExpectedPlanVersion(httpContext, entityParam), clientId);
    }

    private static Long getExpectedPlanVersion(HttpContext httpContext, EntityParam entityParam) {
        String planVersion = EntityParamExtractor.extract(httpContext, entityParam.planVersionParameter(), entityParam.planVersionParameterType());
        if (planVersion != null) {
            try {
                return Long.parseLong(planVersion);
            }
            catch (Exception ex) {
                return null;
            }
        }
        return null;
    }

    private static String extract(HttpContext httpContext, String parameter, ParameterType type) {
        if (type == ParameterType.Path) {
            return EntityParamExtractor.getParameterFromPath(httpContext, parameter);
        }
        if (type == ParameterType.Query) {
            return EntityParamExtractor.getParameterFromQuery(httpContext, parameter);
        }
        return null;
    }

    private static String getParameterFromPath(HttpContext httpContext, String parameter) {
        List ps = httpContext.getUriInfo().getPathSegments(parameter);
        if (ps.isEmpty()) {
            return null;
        }
        return ((PathSegment)ps.get(ps.size() - 1)).getPath();
    }

    private static String getParameterFromQuery(HttpContext httpContext, String parameter) {
        MultivaluedMap queryParams = httpContext.getRequest().getQueryParameters();
        return (String)queryParams.getFirst((Object)parameter);
    }
}

